/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.MailHostConfigurationChangedEvent;
import com.atlassian.stash.exception.NoMailHostConfigurationException;
import com.atlassian.stash.exception.SendingEmailException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.mail.InternalMailService;
import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.mail.MailAttachment;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.mail.MailMessage;
import com.atlassian.stash.mail.MailService;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=MailService.class)
@Service(value="mailService")
public class MailServiceImpl
implements InternalMailService {
    private static final Logger LOG = LoggerFactory.getLogger(MailServiceImpl.class);
    private final ApplicationPropertiesService applicationPropertiesService;
    private final I18nService i18nService;
    private final JavaMailSenderFactory senderFactory;
    private int connectTimeout;
    private volatile JavaMailSender mailSender;
    private int sendTimeout;
    private int testConnectTimeout;
    private int testSendTimeout;

    @Autowired
    public MailServiceImpl(ApplicationPropertiesService propertiesService, I18nService i18nService, JavaMailSenderFactory senderFactory) {
        this.applicationPropertiesService = propertiesService;
        this.i18nService = i18nService;
        this.senderFactory = senderFactory;
    }

    @PostConstruct
    public void initMailSender() {
        this.mailSender = this.buildMailSender(this.applicationPropertiesService.getMailHostConfiguration());
    }

    @Unsecured(value="this needs to be available in all contexts")
    public boolean isMailHostConfigured() {
        return this.mailSender != null;
    }

    @EventListener
    public void onConfigChanged(MailHostConfigurationChangedEvent event) {
        this.mailSender = this.buildMailSender((MailHostConfiguration)event.getNewValue());
    }

    @Unsecured(value="currently we are not restricting messaging by permission")
    public void sendMessage(MailMessage message) throws NoMailHostConfigurationException, SendingEmailException {
        if (this.isMailHostConfigured()) {
            try {
                this.mailSender.send(this.newMimeMailMessagePreparator(message));
            }
            catch (MailException e) {
                this.rethrowAsSendingMailException(e);
            }
        } else {
            KeyedMessage errorMessage = this.i18nService.getKeyedText("stash.service.noemailconfig", "Could not send email because mail host has not been configured. Subject: {0}", new Object[]{message.getSubject()});
            LOG.error(errorMessage.getRootMessage());
            throw new NoMailHostConfigurationException(errorMessage);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void sendTestMessage(MailHostConfiguration configuration, MailMessage message) throws SendingEmailException {
        try {
            this.buildMailSender(configuration, this.testConnectTimeout, this.testSendTimeout).send(this.newMimeMailMessagePreparator(message));
        }
        catch (MailException e) {
            this.rethrowAsSendingMailException(e);
        }
    }

    @Value(value="${mail.timeout.connect}")
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = this.toMilliseconds(connectTimeout);
    }

    @Value(value="${mail.timeout.send}")
    public void setSendTimeout(int sendTimeout) {
        this.sendTimeout = this.toMilliseconds(sendTimeout);
    }

    @Value(value="${mail.test.timeout.connect}")
    public void setTestConnectTimeout(int testConnectTimeout) {
        this.testConnectTimeout = this.toMilliseconds(testConnectTimeout);
    }

    @Value(value="${mail.test.timeout.send}")
    public void setTestSendTimeout(int testSendTimeout) {
        this.testSendTimeout = this.toMilliseconds(testSendTimeout);
    }

    private JavaMailSender buildMailSender(MailHostConfiguration config) {
        return this.buildMailSender(config, this.connectTimeout, this.sendTimeout);
    }

    private JavaMailSender buildMailSender(MailHostConfiguration config, int connectTimeout, int sendTimeout) {
        return this.senderFactory.create(config, connectTimeout, sendTimeout);
    }

    private MimeMessagePreparator newMimeMailMessagePreparator(final MailMessage mailMessage) {
        return new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws Exception {
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, mailMessage.getAttachments().size() > 0);
                MimeMailMessage message = new MimeMailMessage(helper);
                message.setSubject(mailMessage.getSubject());
                message.setText(mailMessage.getText());
                message.setTo((String[])Iterables.toArray((Iterable)mailMessage.getTo(), String.class));
                if (mailMessage.hasFrom()) {
                    message.setFrom(mailMessage.getFrom());
                } else {
                    message.setFrom(MailServiceImpl.this.applicationPropertiesService.getServerEmailAddress());
                }
                if (mailMessage.hasCc()) {
                    message.setCc((String[])Iterables.toArray((Iterable)mailMessage.getCc(), String.class));
                }
                if (mailMessage.hasBcc()) {
                    message.setBcc((String[])Iterables.toArray((Iterable)mailMessage.getBcc(), String.class));
                }
                for (MailAttachment mailAttachment : mailMessage.getAttachments()) {
                    helper.addAttachment(mailAttachment.getFileName(), mailAttachment.getSource());
                }
                for (Map.Entry entry : mailMessage.getHeaders().entrySet()) {
                    mimeMessage.addHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
        };
    }

    private void rethrowAsSendingMailException(MailException e) {
        KeyedMessage errorMessage = this.i18nService.getKeyedText("stash.service.cantsendemail", "The email could not be sent. Please verify the mail server configuration.", new Object[0]);
        LOG.error(errorMessage.getRootMessage());
        throw new SendingEmailException(errorMessage, (Throwable)e);
    }

    private int toMilliseconds(int seconds) {
        return Ints.checkedCast((long)TimeUnit.SECONDS.toMillis(seconds));
    }
}

