/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.license;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.user.UserDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.extras.api.AtlassianLicense;
import com.atlassian.extras.api.LicenseManager;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.stash.StashLicense;
import com.atlassian.extras.decoder.api.LicenseDecoder;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.permission.PermissionGrantedEvent;
import com.atlassian.stash.event.permission.PermissionRevokedEvent;
import com.atlassian.stash.exception.InvalidLicenseException;
import com.atlassian.stash.exception.LicenseLimitException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import com.atlassian.stash.util.DateFormatter;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=LicenseService.class)
@Service(value="licenseService")
public class LicenseServiceImpl
extends AbstractService
implements LicenseService {
    public static final String LICENSE_CACHE = "com.atlassian.extras.api.stash.StashLicense";
    public static final String VALID_KEY = "'valid'";
    public static final String STATUS_KEY = "'status'";
    public static final String LIMIT_KEY = "'limit'";
    public static final String USER_COUNT_CACHE_KEY = "'userCount'";
    public static final String IS_LICENSED_KEY = "'isLicensed:'";
    private static final Logger LOG = LoggerFactory.getLogger(LicenseServiceImpl.class);
    private final CacheManager cacheManager;
    private final CrowdService crowdService;
    private final DateFormatter dateFormatter;
    private final I18nService i18nService;
    private volatile StashLicense license;
    private final LicenseDecoder licenseDecoder;
    private final LicenseManager licenseManager;
    private final PermissionService permissionService;
    private final InternalApplicationPropertiesService propertiesService;
    private final UserService userService;

    @Autowired
    public LicenseServiceImpl(LicenseManager licenseManager, LicenseDecoder licenseDecoder, PermissionService permissionService, InternalApplicationPropertiesService propertiesService, I18nService i18nService, DateFormatter dateFormatter, CacheManager cacheManager, CrowdService crowdService, UserService userService) {
        this.i18nService = i18nService;
        this.licenseDecoder = licenseDecoder;
        this.licenseManager = licenseManager;
        this.permissionService = permissionService;
        this.propertiesService = propertiesService;
        this.dateFormatter = dateFormatter;
        this.cacheManager = cacheManager;
        this.crowdService = crowdService;
        this.userService = userService;
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean hasLicense() {
        return this.license != null;
    }

    @Unsecured(value="everyone needs access to this method")
    public StashLicense getLicense() {
        return this.license;
    }

    @Unsecured(value="Access to the encrypted license is required by UPM")
    public String getLicenseString() {
        return this.propertiesService.getLicense();
    }

    @Cacheable(key="'userCount'", value={"com.atlassian.extras.api.stash.StashLicense"})
    @Unsecured(value="everyone needs access to this method")
    public int getLicensedUsersCount() {
        return this.permissionService.getCountOfUsersWithPermission(Permission.LICENSED_USER);
    }

    @PostConstruct
    public void initialise() {
        String encoded = this.getLicenseString();
        if (encoded == null) {
            LOG.warn("No license has been configured.");
        } else {
            try {
                this.license = this.decodeLicense(encoded);
            }
            catch (Exception e) {
                LOG.warn("Failed to decode the configured license.", (Throwable)e);
            }
        }
    }

    @Unsecured(value="everyone needs access to this method")
    @Cacheable(key="'isLicensed:'+#user.name", value={"com.atlassian.extras.api.stash.StashLicense"})
    public boolean isUserLicensed(StashUser user) {
        return this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
    }

    @Unsecured(value="everyone needs access to this method")
    public boolean canLogin(Principal principal) {
        if (!(principal instanceof StashUser)) {
            return false;
        }
        StashUser user = (StashUser)principal;
        return user.isActive() && this.isUserLicensed(user);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void validateCanLicenseUser(StashUser user, Permission permission) throws LicenseLimitException {
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        StashLicense license = this.getLicense();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.isUserLicensed(user)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        int licenseCount = this.getLicensedUsersCount();
        if (licenseCount < licenseLimit) {
            return;
        }
        KeyedMessage message = this.i18nService.getKeyedText("stash.service.license.userlimit", "You cannot grant this permission to user {0} as it would exceed your license limit of {1}.", new Object[]{user.getDisplayName(), licenseLimit});
        throw new LicenseLimitException(message);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void validateCanLicenseGroup(String group, Permission permission) throws LicenseLimitException {
        Page users;
        if (!Permission.LICENSED_USER.getInheritingPermissions().contains(permission)) {
            return;
        }
        StashLicense license = this.getLicense();
        if (license == null || license.isUnlimitedNumberOfUsers()) {
            return;
        }
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        int licenseLimit = license.getMaximumNumberOfUsers();
        HashSet<String> licensedUsers = new HashSet<String>();
        licensedUsers.addAll(this.permissionService.getUsersWithPermission(Permission.LICENSED_USER));
        PageRequestImpl request = new PageRequestImpl(0, 1000);
        do {
            users = this.userService.getUsersInGroup(group, (PageRequest)request);
            for (String username : users.getValues()) {
                licensedUsers.add(username);
                if (licensedUsers.size() <= licenseLimit) continue;
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.license.grouplimit", "You cannot grant this permission to group {0} as it would exceed your license limit of {1}.", new Object[]{group, licenseLimit});
                throw new LicenseLimitException(message);
            }
        } while ((request = users.getNextPageRequest()) != null);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void validateCanAddUserToGroup(String name, String group) {
        if (!this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, group)) {
            return;
        }
        StashUser user = this.userService.getUser(name);
        if (user != null) {
            this.validateCanLicenseUser(user, Permission.LICENSED_USER);
        }
    }

    @EventListener
    public void onGroupMembershipCreatedEvent(GroupMembershipCreatedEvent event) {
        this.clearCacheIfLicensedGroup(event.getGroupName());
    }

    @EventListener
    public void onPermissionGrantedEvent(PermissionGrantedEvent event) {
        if (Permission.LICENSED_USER.getInheritingPermissions().contains(event.getPermission())) {
            this.clearCache();
        }
    }

    @EventListener
    public void onPermissionRevokedEvent(PermissionRevokedEvent event) {
        if (Permission.LICENSED_USER.getInheritingPermissions().contains(event.getPermission())) {
            this.clearCache();
        }
    }

    @EventListener
    public void onDirectoryUpdated(DirectoryUpdatedEvent event) {
        this.clearCache();
    }

    private void clearCacheIfLicensedGroup(String groupName) {
        if (this.permissionService.hasGlobalGroupPermission(Permission.LICENSED_USER, groupName)) {
            this.clearCache();
        } else {
            PageRequestImpl request = new PageRequestImpl(0, 10);
            Page licensedGroups = this.permissionService.getGrantedGroups(Permission.LICENSED_USER, (PageRequest)request);
            if (!licensedGroups.getIsLastPage()) {
                this.clearCache();
            } else {
                for (String licensedGroup : licensedGroups.getValues()) {
                    if (!this.crowdService.isGroupMemberOfGroup(groupName, licensedGroup)) continue;
                    this.clearCache();
                    break;
                }
            }
        }
    }

    @EventListener
    public void onGroupMembershipDeletedEvent(GroupMembershipDeletedEvent event) {
        this.clearCacheIfLicensedGroup(event.getGroupName());
    }

    @EventListener
    public void onUserDeletedEvent(UserDeletedEvent event) {
        this.clearCache();
    }

    protected void clearCache() {
        this.cacheManager.getCache(LICENSE_CACHE).clear();
    }

    @Cacheable(key="'valid'", value={"com.atlassian.extras.api.stash.StashLicense"})
    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getLicenseValidityMessage() {
        return this.getLicenseValidityMessage(this.getLicense());
    }

    private String getDateString(Date date) {
        return this.dateFormatter.formatDate(date, DateFormatter.FormatType.FULL);
    }

    private KeyedMessage getLicenseValidityMessage(StashLicense license) {
        if (license == null) {
            return this.i18nService.getKeyedText("stash.license.no.license", "No license has been configured.", new Object[0]);
        }
        if (license.isExpired()) {
            if (license.isEvaluation()) {
                return this.i18nService.getKeyedText("stash.license.evaluation.expired", "Your evaluation license is expired.", new Object[0]);
            }
            return this.i18nService.getKeyedText("stash.license.expired", "Your license has expired.", new Object[0]);
        }
        if (license.getMaintenanceExpiryDate() != null && this.propertiesService.getBuildTimestamp() != null && this.propertiesService.getBuildTimestamp().after(license.getMaintenanceExpiryDate())) {
            return this.i18nService.getKeyedText("stash.license.unsupported.upgrade", "Your license is not valid for this version of {0}.", new Object[]{ApplicationConstants.PRODUCT_NAME});
        }
        return null;
    }

    @Cacheable(key="'limit'", value={"com.atlassian.extras.api.stash.StashLicense"})
    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getLicenseOverLimitMessage() {
        if (this.license != null && !this.license.isUnlimitedNumberOfUsers()) {
            int licenseLimit = this.license.getMaximumNumberOfUsers();
            int licenseCount = this.getLicensedUsersCount();
            if (licenseCount > licenseLimit) {
                return this.i18nService.getKeyedText("stash.license.over.limit", "You have more users than your license allows.", new Object[0]);
            }
        }
        return null;
    }

    @Cacheable(key="'status'", value={"com.atlassian.extras.api.stash.StashLicense"})
    @Unsecured(value="everyone needs access to this method")
    public KeyedMessage getLicenseStatus() {
        KeyedMessage message = this.getLicenseValidityMessage();
        if (message == null) {
            message = this.getLicenseOverLimitMessage();
        }
        return message;
    }

    @CacheEvict(allEntries=true, value={"com.atlassian.extras.api.stash.StashLicense"})
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void updateLicense(String encoded) {
        if (StringUtils.isEmpty((String)encoded)) {
            throw new InvalidLicenseException(this.i18nService.getKeyedText("stash.license.empty", "You must provide a license string.", new Object[0]));
        }
        StashLicense stashLicense = this.decodeLicense(encoded);
        KeyedMessage validityMessage = this.getLicenseValidityMessage(stashLicense);
        if (validityMessage != null) {
            throw new InvalidLicenseException(validityMessage);
        }
        this.propertiesService.setLicense(encoded);
        this.license = stashLicense;
    }

    private StashLicense decodeLicense(String license) throws InvalidLicenseException {
        if (this.licenseDecoder.canDecode(license)) {
            AtlassianLicense atlassianLicense = this.licenseManager.getLicense(license);
            StashLicense stashLicense = (StashLicense)atlassianLicense.getProductLicense(Product.STASH);
            if (stashLicense == null) {
                throw new InvalidLicenseException(this.i18nService.getKeyedText("stash.license.not.included", "The provided license does not include an active {0} license and cannot be used.", new Object[]{ApplicationConstants.PRODUCT_NAME}));
            }
            return stashLicense;
        }
        throw new InvalidLicenseException(this.i18nService.getKeyedText("stash.license.invalid", "The provided license is not valid and cannot be used.", new Object[0]));
    }
}

