/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.applinks.spi.link.RemoteErrorListException;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.directory.CrowdDirectoryAttributes;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.ApplicationConstants;
import com.atlassian.stash.internal.jira.CrowdApplicationEntity;
import com.atlassian.stash.jira.IncorrectStashBaseUrlException;
import com.atlassian.stash.jira.JiraSetupException;
import com.atlassian.stash.jira.JiraSetupService;
import com.atlassian.stash.jira.JiraUserCredentialsException;
import com.atlassian.stash.jira.NotAJiraServerException;
import com.atlassian.stash.jira.StashApplicationTypeNotInstalledException;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@AvailableToPlugins(value=JiraSetupService.class)
public class JiraSetupServiceImpl
implements JiraSetupService {
    private static final Logger LOG = LoggerFactory.getLogger(JiraSetupServiceImpl.class);
    private static final ImmutableSet<OperationType> ALLOWED_DIRECTORY_OPERATIONS = Sets.immutableEnumSet((Enum)OperationType.UPDATE_USER_ATTRIBUTE, (Enum[])new OperationType[]{OperationType.UPDATE_GROUP_ATTRIBUTE});
    private static final String CROWD_DIRECTORY_NAME = "JIRA User Directory";
    private static final int POLLING_INTERVAL_SECONDS = 3600;
    private static final String JIRA_SYSADMIN_GROUP = "jira-administrators";
    private final MutatingApplicationLinkService applicationLinkService;
    private final TypeAccessor typeAccessor;
    private final ManifestRetriever manifestRetriever;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;
    private final ApplicationManager applicationManager;
    private final I18nService i18nService;
    private final PermissionAdminService permissionAdminService;
    private final HostApplication hostApplication;

    @Autowired
    public JiraSetupServiceImpl(MutatingApplicationLinkService applicationLinkService, TypeAccessor typeAccessor, HostApplication hostApplication, ManifestRetriever manifestRetriever, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager, PermissionAdminService permissionAdminService, ApplicationManager applicationManager, I18nService i18nService) {
        this.applicationLinkService = applicationLinkService;
        this.typeAccessor = typeAccessor;
        this.hostApplication = hostApplication;
        this.manifestRetriever = manifestRetriever;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
        this.permissionAdminService = permissionAdminService;
        this.applicationManager = applicationManager;
        this.i18nService = i18nService;
    }

    @Transactional(rollbackFor={JiraSetupException.class})
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void createLinkWithJira(URI remoteRpcUrl, URI localRpcUrl, String username, String password, boolean setupUserManagement) throws JiraSetupException {
        remoteRpcUrl = UrlUtils.trimTrailingSlashesFromPath((URI)remoteRpcUrl);
        localRpcUrl = UrlUtils.trimTrailingSlashesFromPath((URI)localRpcUrl);
        this.checkServerIsJiraWithEmbeddedCrowd(remoteRpcUrl);
        this.checkAdminCredentials(remoteRpcUrl, username, password);
        try {
            ApplicationLink applicationLink = this.createReciprocatedApplicationLink(remoteRpcUrl, localRpcUrl, username, password);
            this.authenticateApplicationLink(applicationLink, username, password, localRpcUrl);
            if (setupUserManagement) {
                CrowdApplicationEntity crowdApplication = this.createStashApplicationInCrowd(applicationLink, username, password);
                this.setupJiraDirectory(remoteRpcUrl, crowdApplication.getName(), crowdApplication.getPassword());
                this.grantPermissionsToStandardJiraGroups();
            }
        }
        catch (JiraSetupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.failed.to.setup.jira.integration", "Failed to setup JIRA integration: {0}", new Object[]{e.getMessage()}), (Throwable)e);
        }
    }

    @VisibleForTesting
    void checkServerIsJiraWithEmbeddedCrowd(URI remoteRpcUrl) throws JiraSetupException {
        Manifest manifest;
        try {
            manifest = this.manifestRetriever.getManifest(remoteRpcUrl);
        }
        catch (ManifestNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failed to retrieve manifest from " + remoteRpcUrl, (Throwable)e);
            }
            throw new NotAJiraServerException(this.i18nService.getText("stash.web.jira.setup.failed.to.retrieve.manifest", "There doesn''t seem to be a running JIRA server (version 4.3 or later) at this URL.", new Object[0]), (Throwable)e);
        }
        if (!manifest.getTypeId().equals((Object)TypeId.getTypeId((com.atlassian.applinks.api.ApplicationType)this.getJiraApplicationType()))) {
            throw new NotAJiraServerException(this.i18nService.getText("stash.web.jira.setup.wrong.app.url", "This URL appears to be a {0} server. Please specify a JIRA server (version 4.3 or later).", new Object[]{StringUtils.capitalize((String)manifest.getTypeId().get())}));
        }
    }

    protected void checkAdminCredentials(URI remoteRpcUrl, String username, String password) throws JiraSetupException {
        try {
            if (!this.applicationLinkService.isAdminUserInRemoteApplication(remoteRpcUrl, username, password)) {
                throw new JiraUserCredentialsException(this.i18nService.getText("stash.web.jira.setup.bad.credentials", "The password was incorrect or the user {0} is not a system administrator in the specified JIRA server.", new Object[]{username}));
            }
        }
        catch (ResponseException e) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.credentials.exception", "An exception occurred whilst checking the specified JIRA user credentials.", new Object[]{e}));
        }
    }

    protected ApplicationLink createReciprocatedApplicationLink(URI remoteRpcUrl, URI localRpcUrl, String username, String password) throws JiraSetupException {
        ApplicationLink applicationLink;
        try {
            this.applicationLinkService.createReciprocalLink((URI)Preconditions.checkNotNull((Object)remoteRpcUrl, (Object)"remoteRpcUrl"), (URI)Preconditions.checkNotNull((Object)localRpcUrl, (Object)"localRpcUrl"), (String)Preconditions.checkNotNull((Object)username, (Object)"username"), (String)Preconditions.checkNotNull((Object)password, (Object)"password"));
        }
        catch (RemoteErrorListException e) {
            if (JiraSetupServiceImpl.remoteErrorMessageStartsWith(e, "There is no application type ")) {
                throw new StashApplicationTypeNotInstalledException(this.i18nService.getText("stash.web.jira.setup.remote.stash.application.type.missing", "The Stash ApplicationType does not seem to be installed in the remote JIRA instance.", new Object[0]), (Throwable)e);
            }
            if (JiraSetupServiceImpl.remoteErrorMessageStartsWith(e, "Can't access application via URL")) {
                throw new IncorrectStashBaseUrlException(this.i18nService.getText("stash.web.jira.setup.failed.to.retrieve.manifest", "JIRA couldn''t communicate with Stash using this URL.", new Object[0]), (Throwable)e);
            }
            this.throwDefaultRecriprocalActionFailedException(remoteRpcUrl, localRpcUrl, (ReciprocalActionException)((Object)e));
        }
        catch (ReciprocalActionException e) {
            this.throwDefaultRecriprocalActionFailedException(remoteRpcUrl, localRpcUrl, e);
        }
        try {
            ApplicationLinkDetails linkDetails = ApplicationLinkDetails.builder().rpcUrl(remoteRpcUrl).displayUrl(remoteRpcUrl).isPrimary(true).name(JiraSetupServiceImpl.generateLinkName(remoteRpcUrl)).build();
            applicationLink = this.applicationLinkService.createApplicationLink((com.atlassian.applinks.api.ApplicationType)this.getJiraApplicationType(), linkDetails);
        }
        catch (ManifestNotFoundException e) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.failed.to.retrieve.manifest.during.applink.creation", "JIRA stopped responding during application link creation. Please check that it is running and try again.", new Object[0]), (Throwable)e);
        }
        return applicationLink;
    }

    private JiraApplicationType getJiraApplicationType() throws JiraSetupException {
        JiraApplicationType jiraType = (JiraApplicationType)this.typeAccessor.getApplicationType(JiraApplicationType.class);
        if (jiraType == null) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.local.jira.application.type.missing", "Failed to load the application type: {0}. Have you disabled some modules of the Application Links plugin?", new Object[]{JiraApplicationType.class}));
        }
        return jiraType;
    }

    protected static boolean remoteErrorMessageStartsWith(RemoteErrorListException e, String text) {
        for (String msg : e.getErrors()) {
            if (!msg.startsWith(text)) continue;
            return true;
        }
        return false;
    }

    private void throwDefaultRecriprocalActionFailedException(URI remoteRpcUrl, URI localRpcUrl, ReciprocalActionException e) throws JiraSetupException {
        throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.generic.reciprocal.application.link.failure", "Failed to create application link from JIRA server at {0} to this Stash server at {1}.", new Object[]{remoteRpcUrl, localRpcUrl}), (Throwable)e);
    }

    protected void authenticateApplicationLink(ApplicationLink applicationLink, String username, String password, URI localRpcUrl) throws JiraSetupException {
        AuthenticationScenario authenticationScenario = new AuthenticationScenario(){

            public boolean isCommonUserBase() {
                return false;
            }

            public boolean isTrusted() {
                return true;
            }
        };
        try {
            this.applicationLinkService.configureAuthenticationForApplicationLink(applicationLink, authenticationScenario, username, password);
        }
        catch (AuthenticationConfigurationException e) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.applink.authentication.configuration.failure", "Failed to authenticate the application link between the JIRA server at {0} to this Stash server at {1}.", new Object[]{applicationLink.getRpcUrl(), localRpcUrl}), (Throwable)e);
        }
    }

    private CrowdApplicationEntity createStashApplicationInCrowd(ApplicationLink applicationLink, String username, String password) throws JiraSetupException {
        ApplicationLinkRequest request;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
        try {
            request = requestFactory.createRequest(Request.MethodType.POST, "rest/appmanagement/1/application?include-request-address=true");
        }
        catch (CredentialsRequiredException e) {
            throw new IllegalStateException("Anonymous authentication provider should never throw CredentialsRequiredException", e);
        }
        request.addBasicAuthentication(username, password);
        CrowdApplicationEntity applicationEntity = this.createApplicationEntity();
        request.setEntity((Object)applicationEntity);
        CrowdResult crowdResult = this.executeRequest(request);
        if (!crowdResult.isOk()) {
            throw new JiraSetupException(crowdResult.message, (Throwable)crowdResult.exception);
        }
        return applicationEntity;
    }

    private CrowdApplicationEntity createApplicationEntity() {
        ApplicationType type = ApplicationType.GENERIC_APPLICATION;
        String appname = this.generateName(type);
        String password = DefaultSecureTokenGenerator.getInstance().generateToken();
        String description = "Automatically created by the setup of " + type.getDisplayName() + " on " + SimpleDateFormat.getDateInstance().format(new Date());
        return new CrowdApplicationEntity(type, appname, password, description, true);
    }

    private String generateName(ApplicationType type) {
        ApplicationId id = this.hostApplication.getId();
        URI url = this.hostApplication.getBaseUrl();
        return type.getDisplayName() + " - " + StringUtils.defaultString((String)url.getHost()) + " - " + id;
    }

    private CrowdResult executeRequest(ApplicationLinkRequest request) {
        try {
            return (CrowdResult)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<CrowdResult>(){

                public CrowdResult credentialsRequired(Response response) {
                    throw new IllegalStateException("Anonymous authentication provider should never invoke ApplicationLinkResponseHandler#credentialsRequired()");
                }

                public CrowdResult handle(Response response) throws ResponseException {
                    if (!response.isSuccessful()) {
                        return new CrowdResult(CrowdResultType.NOT_20x, JiraSetupServiceImpl.this.i18nService.getText("stash.web.jira.setup.failed.to.register.stash.crowd.configuration", "Failed to register Stash configuration in JIRA for shared user management. Received: {0} {1}", new Object[]{response.getStatusCode(), response.getStatusText()}), null);
                    }
                    return new CrowdResult(CrowdResultType.OK, null, null);
                }
            });
        }
        catch (ResponseException e) {
            return new CrowdResult(CrowdResultType.BAD_RESPONSE, this.i18nService.getText("stash.web.jira.setup.failed.to.register.stash.crowd.configuration", "Failed to register Stash configuration in JIRA for shared user management. An exception occurred whilst communicating with JIRA: {0}", new Object[]{e}), (Exception)((Object)e));
        }
    }

    protected void setupJiraDirectory(URI crowdServerUrl, String applicationName, String applicationPassword) throws JiraSetupException {
        if (this.directoryNameInUse(CROWD_DIRECTORY_NAME)) {
            throw new JiraSetupException(this.i18nService.getText("stash.web.jira.setup.crowd.directory.name.already.exists", "Can not proceed with setting up JIRA user directory. A Crowd directory with the name {0} already exists.", new Object[]{CROWD_DIRECTORY_NAME}));
        }
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        Date now = new Date();
        builder.setCreatedDate(now);
        builder.setUpdatedDate(now);
        builder.setAllowedOperations(ALLOWED_DIRECTORY_OPERATIONS);
        builder.setActive(true);
        builder.setImplementationClass(RemoteCrowdDirectory.class.getName());
        builder.setName(CROWD_DIRECTORY_NAME);
        builder.setType(DirectoryType.CROWD);
        CrowdDirectoryAttributes attributes = new CrowdDirectoryAttributes();
        attributes.setApplicationName(applicationName);
        attributes.setApplicationPassword(applicationPassword);
        attributes.setCrowdServerUrl(crowdServerUrl.toASCIIString());
        attributes.setNestedGroupsEnabled(false);
        attributes.setCrowdServerSynchroniseIntervalInSeconds(Long.toString(3600L));
        attributes.setIncrementalSyncEnabled(true);
        builder.setAttributes(attributes.toAttributesMap());
        Directory directory = this.crowdDirectoryService.addDirectory(builder.toDirectory());
        LOG.info("JIRA user directory created: [ {} ], type: [ {} ]", (Object)directory.getName(), (Object)directory.getType());
        try {
            Application stashApplication = this.applicationManager.findByName(ApplicationConstants.CROWD_APPLICATION_NAME);
            OperationType[] operationTypes = (OperationType[])ALLOWED_DIRECTORY_OPERATIONS.toArray((Object[])new OperationType[ALLOWED_DIRECTORY_OPERATIONS.size()]);
            this.applicationManager.addDirectoryMapping(stashApplication, directory, true, operationTypes);
        }
        catch (ApplicationNotFoundException e) {
            throw new IllegalStateException("Couldn't find mapping for " + ApplicationConstants.CROWD_APPLICATION_NAME, e);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalStateException("Couldn't find newly created directory JIRA User Directory", e);
        }
    }

    private boolean directoryNameInUse(String directoryName) {
        return !this.getDirectoriesWithName(directoryName).isEmpty();
    }

    private List<Directory> getDirectoriesWithName(String directoryName) {
        EntityQuery directoryQuery = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).exactlyMatching((Object)directoryName)).returningAtMost(-1);
        return this.directoryManager.searchDirectories(directoryQuery);
    }

    private void grantPermissionsToStandardJiraGroups() {
        this.permissionAdminService.setGlobalPermission(Permission.SYS_ADMIN, JIRA_SYSADMIN_GROUP);
    }

    protected static String generateLinkName(URI remoteRpcUrl) {
        String name = "JIRA";
        if (remoteRpcUrl.getHost() != null) {
            name = remoteRpcUrl.getHost() + " " + name;
        }
        return name;
    }

    private static class CrowdResult {
        final CrowdResultType type;
        final String message;
        final Exception exception;

        private CrowdResult(CrowdResultType type, String message, Exception exception) {
            this.type = type;
            this.message = message;
            this.exception = exception;
        }

        boolean isOk() {
            return this.type == CrowdResultType.OK;
        }
    }

    private static enum CrowdResultType {
        NOT_20x,
        BAD_RESPONSE,
        OK;

    }
}

