/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmClient;
import com.atlassian.utils.process.IOUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepositorySnapshotServiceImpl
implements RepositorySnapshotService {
    private static final Logger log = LoggerFactory.getLogger(RepositorySnapshotServiceImpl.class);
    private static Function<Long, String> TIMESTAMP_TO_STRING = new Function<Long, String>(){

        public String apply(@Nullable Long input) {
            return Long.toString(input);
        }
    };
    private final File snapshotDir;

    @Autowired
    public RepositorySnapshotServiceImpl(ApplicationSettings settings) {
        this.snapshotDir = new File(settings.getCacheDir(), "idx-snapshots");
        this.snapshotDir.mkdirs();
    }

    private File getRepositorySnapshotDir(Repository repository) {
        return new File(this.snapshotDir, repository.getId().toString());
    }

    private File getSnapshotFile(Repository repository, Long timestamp) {
        File repositorySnapshotDir = this.getRepositorySnapshotDir(repository);
        repositorySnapshotDir.mkdirs();
        return new File(repositorySnapshotDir, Long.toString(timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createRepositorySnapshot(Repository repo, ScmClient client, Long timestamp) {
        try {
            final FileWriter writer = new FileWriter(this.getSnapshotFile(repo, timestamp));
            try {
                client.getHeadsCommand(repo, new RefCallback(){

                    public void onRef(Ref ref) {
                        try {
                            writer.write(ref.getLatestChangeset() + "\n");
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }).call();
            }
            finally {
                IOUtils.closeQuietly((Closeable)writer);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not open snapshot file for writing", e);
        }
    }

    @EventListener
    public void onDeleteRepository(RepositoryDeletedEvent event) {
        this.deleteSnapshots(event.getRepository());
    }

    @Override
    public Iterable<String> getRepositorySnapshot(Repository repo, Long timestamp) {
        if (timestamp != null) {
            return new RepositorySnapshotIterable(this.getSnapshotFile(repo, timestamp));
        }
        return Collections.emptySet();
    }

    @Override
    public void deleteSnapshots(Repository repository) {
        try {
            FileUtils.deleteDirectory((File)this.getRepositorySnapshotDir(repository));
        }
        catch (IOException e) {
            throw new RuntimeException("Error deleting the snapshot files for repository " + repository.getName(), e);
        }
    }

    @Override
    public void pruneSnapshots(Repository repo, Set<Long> timestampsToKeep) {
        ImmutableSet snapshotFilesToKeep = ImmutableSet.copyOf((Iterable)Iterables.transform(timestampsToKeep, TIMESTAMP_TO_STRING));
        File snapshotDir = this.getRepositorySnapshotDir(repo);
        for (File snapshotFile : snapshotDir.listFiles()) {
            if (snapshotFilesToKeep.contains(snapshotFile.getName()) || snapshotFile.delete()) continue;
            snapshotFile.deleteOnExit();
        }
    }

    private static class RepositorySnapshotIterable
    implements Iterable<String> {
        private final File file;

        public RepositorySnapshotIterable(File file) {
            this.file = file;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private static final int PAGE_SIZE = 100;
                private final Deque<String> nextValues = new LinkedList<String>();
                private int offset = 0;

                private void readPage() {
                    BufferedReader reader = null;
                    try {
                        int lineNumber;
                        reader = new BufferedReader(new FileReader(RepositorySnapshotIterable.this.file));
                        for (lineNumber = 0; lineNumber < this.offset; ++lineNumber) {
                            reader.readLine();
                        }
                        String line = null;
                        int lastLine = this.offset + 100;
                        while (lineNumber < lastLine && (line = reader.readLine()) != null) {
                            this.nextValues.addLast(line);
                            ++lineNumber;
                        }
                        this.offset = line != null ? lastLine : -1;
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)reader);
                }

                @Override
                public boolean hasNext() {
                    if (this.nextValues.isEmpty() && this.offset >= 0) {
                        this.readPage();
                    }
                    return !this.nextValues.isEmpty();
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        return this.nextValues.poll();
                    }
                    throw new NoSuchElementException("No more entries are available");
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
    }
}

