/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.history;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.InternalChangeset;
import com.atlassian.stash.history.HistoryService;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmClient;
import com.atlassian.stash.scm.ScmClientProvider;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Function;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=HistoryService.class)
@PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
@Service(value="historyService")
public class HistoryServiceImpl
extends AbstractScmService
implements HistoryService {
    private final ChangesetIndex changesetIndex;
    private final ChangesetAttributeConfiguration attributeConfiguration;
    @Value(value="${page.max.changes}")
    private int maxChanges;
    @Value(value="${page.max.changesets}")
    private int maxChangesets;

    @Autowired
    public HistoryServiceImpl(ScmClientProvider clientProvider, ChangesetIndex changesetIndex, ChangesetAttributeConfiguration attributeConfiguration) {
        super(clientProvider);
        this.attributeConfiguration = attributeConfiguration;
        this.changesetIndex = changesetIndex;
    }

    @Nonnull
    public Page<Change> getChanges(@Nonnull Repository repository, @Nonnull String changesetId, @Nonnull String parentId, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChanges);
        Page page = (Page)this.getScmClient(repository).getChangesCommand(repository, changesetId, parentId, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId) {
        return this.getChangeset(repository, changesetId, null, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path) {
        return this.getChangeset(repository, changesetId, path, null);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable Collection<String> attributesToLoad) {
        return this.getChangeset(repository, changesetId, null, attributesToLoad);
    }

    @Nonnull
    public Changeset getChangeset(@Nonnull Repository repository, @Nonnull String changesetId, @Nullable String path, @Nullable Collection<String> attributesToLoad) {
        ScmClient scmClient = this.getScmClient(repository);
        Changeset changeset = (Changeset)scmClient.getChangesetCommand(repository, changesetId, path).call();
        if (CollectionUtils.isNotEmpty(attributesToLoad = this.getAttributesToLoad(repository, attributesToLoad))) {
            changeset = this.loadAttributes(changeset, attributesToLoad);
        }
        return changeset;
    }

    private Changeset loadAttributes(Changeset changeset, Collection<String> attributeNames) {
        AttributeMap attributeMap = this.changesetIndex.getAttributeValues(changeset.getId(), attributeNames);
        return new InternalChangeset.Builder(changeset).addAttributes(attributeMap).build();
    }

    @Nonnull
    public Page<Changeset> getChangesets(@Nonnull Repository repository, String path, String branch, @Nonnull PageRequest pageRequest) {
        return this.getChangesets(repository, path, branch, Collections.<String>emptySet(), pageRequest);
    }

    @Nonnull
    public Page<Changeset> getChangesets(Repository repository, String path, String branch, Collection<String> attributesToLoad, PageRequest pageRequest) {
        ScmClient scmClient = this.getScmClient(repository);
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChangesets);
        attributesToLoad = this.getAttributesToLoad(repository, attributesToLoad);
        Page<Changeset> changesets = (Page<Changeset>)scmClient.getChangelogCommand(repository, path, branch, pageRequest).call();
        if (CollectionUtils.isNotEmpty(attributesToLoad)) {
            changesets = this.loadAttributes(changesets, attributesToLoad);
        }
        return changesets;
    }

    @Nonnull
    public Page<DetailedChangeset> getDetailedChangesets(Repository repository, Collection<String> changesetIds, int maxChangesPerChangeset, PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxChangesets);
        maxChangesPerChangeset = Math.min(maxChangesPerChangeset, this.maxChanges);
        Page page = (Page)this.getScmClient(repository).getDetailedChangesetsCommand(repository, changesetIds, maxChangesPerChangeset, pageRequest).call();
        if (page == null) {
            page = PageUtils.createPage(Collections.emptyList(), (PageRequest)pageRequest);
        }
        return page;
    }

    private Page<Changeset> loadAttributes(Page<Changeset> changesetPage, Collection<String> attributeNames) {
        HashSet csIds = Sets.newHashSet();
        for (Changeset changeset : changesetPage.getValues()) {
            csIds.add(changeset.getId());
        }
        final Map csToAttributeMap = this.changesetIndex.getAttributeValues((Collection)csIds, attributeNames);
        return changesetPage.transform((Function)new Function<Changeset, Changeset>(){

            public Changeset apply(Changeset input) {
                AttributeMap attributeMap = (AttributeMap)csToAttributeMap.get(input.getId());
                if (attributeMap != null && !attributeMap.isEmpty()) {
                    return new InternalChangeset.Builder(input).addAttributes(attributeMap).build();
                }
                return input;
            }
        });
    }

    private Collection<String> getAttributesToLoad(Repository repository, Collection<String> attributesRequested) {
        HashSet attributes = Sets.newHashSet();
        if (attributesRequested != null) {
            attributes.addAll(attributesRequested);
        }
        attributes.addAll(this.attributeConfiguration.getAttributesToPreload(repository));
        return attributes;
    }
}

