/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.stash.internal.crowd.Filter;
import com.google.common.base.Function;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public abstract class NameMatchingFilter<T, E>
extends Filter<T, E> {
    private final Pattern pattern;

    protected NameMatchingFilter(CrowdService crowdService, @Nullable Function<T, E> transform, @Nullable String filter) {
        super(crowdService, transform);
        this.pattern = StringUtils.isBlank((String)filter) ? null : Pattern.compile("(\\b|^|[^\\p{L}\\p{N}])" + Pattern.quote(filter), 2);
    }

    protected boolean filterMatchesOneOf(String ... values) {
        if (this.pattern == null) {
            return true;
        }
        for (String value : values) {
            if (value == null || !this.pattern.matcher(value).find()) continue;
            return true;
        }
        return false;
    }
}

