/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageImpl;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class Filter<T, E> {
    static final int FETCH_SIZE = 100;
    private final CrowdService crowdService;
    private final Function<T, E> transform;

    Filter(CrowdService crowdService, @Nullable Function<T, E> transform) {
        this.crowdService = crowdService;
        this.transform = transform;
    }

    abstract Query<T> getQuery(String var1, int var2, int var3);

    abstract boolean isMatch(T var1);

    Page<E> scan(@Nonnull PageRequest pageRequest, @Nonnull String entity) {
        int limit = pageRequest.getLimit() + 1;
        ArrayList matches = new ArrayList(limit);
        int matched = 0;
        int offset = 0;
        while (matches.size() < limit) {
            Iterable candidates = this.crowdService.search(this.getQuery(entity, offset, 100));
            for (Object candidate : candidates) {
                if (!this.isMatch(candidate) || matched++ < pageRequest.getStart()) continue;
                matches.add(candidate);
                if (matches.size() < limit) continue;
                break;
            }
            if (Iterables.size((Iterable)candidates) < 100) break;
            offset += 100;
        }
        boolean isLastPage = matches.size() <= pageRequest.getLimit();
        List page = matches.subList(0, Math.min(matches.size(), pageRequest.getLimit()));
        return new PageImpl(pageRequest, this.convert(page), isLastPage);
    }

    private Iterable<E> convert(List<T> page) {
        if (this.transform == null) {
            return page;
        }
        return Iterables.transform(page, this.transform);
    }
}

