/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.content;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.Blame;
import com.atlassian.stash.content.ContentService;
import com.atlassian.stash.content.ContentTreeNode;
import com.atlassian.stash.content.DiffContentCallback;
import com.atlassian.stash.content.DirectoryRevision;
import com.atlassian.stash.content.FileContentCallback;
import com.atlassian.stash.exception.CommandException;
import com.atlassian.stash.exception.ServerException;
import com.atlassian.stash.exception.ServiceException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.scm.AbstractScmService;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.Command;
import com.atlassian.stash.scm.ScmClientProvider;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageRequestImpl;
import com.google.common.base.Throwables;
import java.io.OutputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ContentService.class)
@PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_READ')")
@Service(value="contentService")
public class ContentServiceImpl
extends AbstractScmService
implements ContentService {
    public static final String MAX_SOURCE_LINE_LENGTH = "${page.max.source.length}";
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentServiceImpl.class);
    private final I18nService i18nService;
    @Value(value="${page.max.diff.lines}")
    private int maxDiffLines;
    @Value(value="${page.max.directory.children}")
    private int maxDirectoryChildren;
    @Value(value="${page.max.source.length}")
    private int maxLineLength;
    @Value(value="${page.max.source.lines}")
    private int maxSourceLines;

    @Autowired
    public ContentServiceImpl(ScmClientProvider clientProvider, I18nService i18nService) {
        super(clientProvider);
        this.i18nService = i18nService;
    }

    public List<Blame> getBlame(Repository repository, String objectId, String path, PageRequest pageRequest) {
        return (List)this.getScmClient(repository).getBlameCommand(repository, objectId, path, pageRequest).call();
    }

    public DirectoryRevision getDirectory(Repository repository, String csid, String path, PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxDirectoryChildren);
        return (DirectoryRevision)this.getScmClient(repository).getDirectoryCommand(repository, csid, path, pageRequest).call();
    }

    public ContentTreeNode.Type getType(Repository repository, String objectId, String path) {
        return (ContentTreeNode.Type)this.getScmClient(repository).getTypeCommand(repository, objectId, path).call();
    }

    public void streamDiff(Repository repository, String sinceId, String untilId, String path, DiffContentCallback callback) {
        PageRequestImpl pageRequest = new PageRequestImpl(0, this.maxDiffLines);
        Command command = this.getScmClient(repository).getDiffStreamCommand(repository, sinceId, untilId, path, (PageRequest)pageRequest, this.maxLineLength, callback);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOGGER.error("Error occurred when streaming diff in repository '" + repository.getName() + "' from revision '" + sinceId + "' to revision '" + untilId + "' at path '" + path, rootCause);
            throw new ServerException(this.i18nService.getKeyedText("stash.service.unexpected", "An unexpected error occurred while processing your request. See debug logs for more details.", new Object[]{rootCause}));
        }
    }

    public void streamFile(Repository repository, String objectId, String path, PageRequest pageRequest, boolean withBlame, FileContentCallback callback) throws ServiceException {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxSourceLines);
        Command command = this.getScmClient(repository).getFileStreamCommand(repository, objectId, path, pageRequest, this.maxLineLength, withBlame, callback);
        try {
            command.call();
        }
        catch (CommandException e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            LOGGER.error("Error occurred when streaming file in repository '" + repository.getName() + "' at revision '" + objectId + "' at path '" + path, rootCause);
            throw new ServerException(this.i18nService.getKeyedText("stash.service.unexpected", "An unexpected error occurred while processing your request. See debug logs for more details.", new Object[]{rootCause}));
        }
    }

    public void streamFile(Repository repository, String objectId, String path, OutputStream outputStream) throws ServiceException {
        this.getScmClient(repository).getFileStreamCommand(repository, objectId, path, outputStream).call();
    }
}

