/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.StateTransferringExecutor;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransferringExecutorService
extends StateTransferringExecutor
implements ExecutorService {
    private final ExecutorService delegate;
    private final Logger log = LoggerFactory.getLogger(StateTransferringExecutorService.class);

    public StateTransferringExecutorService(ExecutorService delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.wrap(tasks), timeout, unit);
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(this.wrap(callable));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(this.wrap(runnable), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(this.wrap(runnable));
    }

    protected <T> Callable<T> wrap(Callable<T> callable) {
        return new StateTransferringCallable<T>(callable, this.getState());
    }

    protected <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> callables) {
        final TransferableState state = this.getState();
        return Collections2.transform(callables, (Function)new Function<Callable<T>, Callable<T>>(){

            public Callable<T> apply(Callable<T> callable) {
                return new StateTransferringCallable(callable, state);
            }
        });
    }

    protected class StateTransferringCallable<T>
    implements Callable<T> {
        private final Callable<T> delegate;
        private final TransferableState state;

        public StateTransferringCallable(Callable<T> delegate, TransferableState state) {
            this.delegate = delegate;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public T call() throws Exception {
            try {
                this.state.apply();
                try {
                    T t = this.delegate.call();
                    return t;
                }
                finally {
                    this.state.remove();
                }
            }
            catch (Exception e) {
                StateTransferringExecutorService.this.log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                StateTransferringExecutorService.this.log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateTransferringCallable)) {
                return false;
            }
            StateTransferringCallable that = (StateTransferringCallable)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

