/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.concurrent;

import com.atlassian.stash.internal.concurrent.StateTransferringExecutorService;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StateTransferringExecutor
implements Executor {
    private final Logger log = LoggerFactory.getLogger(StateTransferringExecutorService.class);
    private final Executor delegate;
    private List<StatefulService> services;

    public StateTransferringExecutor(Executor delegate) {
        this.delegate = delegate;
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(this.wrap(runnable));
    }

    protected TransferableState getState() {
        return new TransferableState(){
            private final List<TransferableState> states;
            {
                this.states = ImmutableList.copyOf((Collection)Collections2.transform((Collection)StateTransferringExecutor.this.services, (Function)new Function<StatefulService, TransferableState>(){

                    public TransferableState apply(StatefulService service) {
                        return service.getState();
                    }
                }));
            }

            @Override
            public void apply() {
                for (TransferableState state : this.states) {
                    try {
                        state.apply();
                    }
                    catch (Exception e) {
                        StateTransferringExecutor.this.log.warn("Failed to apply thread state", (Throwable)e);
                    }
                }
            }

            @Override
            public void remove() {
                for (TransferableState state : this.states) {
                    try {
                        state.remove();
                    }
                    catch (Exception e) {
                        StateTransferringExecutor.this.log.warn("Failed to remove thread state", (Throwable)e);
                    }
                }
            }
        };
    }

    protected Runnable wrap(Runnable runnable) {
        return new StateTransferringRunnable(runnable, this.getState());
    }

    @Autowired
    @VisibleForTesting
    void setServices(StatefulService ... services) {
        this.services = ImmutableList.copyOf((Object[])services);
    }

    protected class StateTransferringRunnable
    implements Runnable {
        private final Runnable delegate;
        private final TransferableState state;

        public StateTransferringRunnable(Runnable delegate, TransferableState state) {
            this.delegate = delegate;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.state.apply();
                try {
                    this.delegate.run();
                }
                finally {
                    this.state.remove();
                }
            }
            catch (RuntimeException e) {
                StateTransferringExecutor.this.log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
            catch (Error e) {
                StateTransferringExecutor.this.log.error("Error while processing asynchronous task", (Throwable)e);
                throw e;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StateTransferringRunnable)) {
                return false;
            }
            StateTransferringRunnable that = (StateTransferringRunnable)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

