/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.check.LicensingCheck;
import com.atlassian.stash.scm.ScmRequest;
import com.atlassian.stash.scm.ScmRequestCheck;
import com.atlassian.stash.scm.ScmRequestCheckModuleDescriptor;
import com.atlassian.stash.scm.ScmRequestCheckService;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="scmRequestCheckService")
@AvailableToPlugins(value=ScmRequestCheckService.class)
@Transactional(readOnly=true)
public class ScmRequestCheckServiceImpl
implements ScmRequestCheckService {
    private final PluginAccessor pluginAccessor;
    private final LicensingCheck licensingCheck;
    private static final Function<ScmRequestCheckModuleDescriptor, ScmRequestCheck> TO_MODULE = new Function<ScmRequestCheckModuleDescriptor, ScmRequestCheck>(){

        public ScmRequestCheck apply(ScmRequestCheckModuleDescriptor scmRequestCheckModuleDescriptor) {
            return scmRequestCheckModuleDescriptor.getModule();
        }
    };

    @Autowired
    public ScmRequestCheckServiceImpl(PluginAccessor pluginAccessor, LicensingCheck licensingCheck) {
        this.pluginAccessor = pluginAccessor;
        this.licensingCheck = licensingCheck;
    }

    @Unsecured(value="Validating whether an SCM request can proceed does not require a specific permission")
    public boolean checkActionAllowed(ScmRequest request) throws IOException {
        if (request.isInvalid()) {
            return true;
        }
        ArrayList requestCheckDescriptors = Lists.newArrayList((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(ScmRequestCheckModuleDescriptor.class));
        Collections.sort(requestCheckDescriptors);
        Iterable requestChecks = Iterables.concat(Collections.singleton(this.licensingCheck), (Iterable)Iterables.transform((Iterable)requestCheckDescriptors, TO_MODULE));
        for (ScmRequestCheck check : requestChecks) {
            if (check.check(request)) continue;
            return false;
        }
        return true;
    }
}

