/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.check;

import com.atlassian.stash.Product;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.nav.NavBuilder;
import com.atlassian.stash.scm.ScmRequest;
import com.atlassian.stash.scm.ScmRequestCheck;
import com.atlassian.stash.user.StashAuthenticationContext;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicensingCheck
implements ScmRequestCheck {
    private final StashAuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final NavBuilder navBuilder;

    @Autowired
    public LicensingCheck(LicenseService licenseService, I18nService i18nService, NavBuilder navBuilder, StashAuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.navBuilder = navBuilder;
    }

    public boolean check(@Nonnull ScmRequest request) throws IOException {
        KeyedMessage licenseMessage = this.licenseService.getLicenseStatus();
        if (request.isWrite() && licenseMessage != null) {
            request.sendError(this.i18nService.getText("stash.scm.license.limit.exceeded", "License limit exceeded", new Object[0]), this.i18nService.getText("stash.scm.license.limit.exceeded.detail", "{2} Pushing has been disabled until the license is brought back into compliance.\n\nVisit {0} at {1} for more details.", new Object[]{Product.NAME, this.navBuilder.buildAbsolute(), licenseMessage.getLocalisedMessage()}));
            return false;
        }
        if (this.authenticationContext.getCurrentUser() != null && !this.licenseService.canLogin((Principal)this.authenticationContext.getCurrentUser())) {
            request.sendError(this.i18nService.getText("stash.scm.unlicensed.user", "Unlicensed user", new Object[0]), this.i18nService.getText("stash.scm.unlicensed.user.detail", "You do not have permission to access {0}. Please ask an administrator to grant you access.", new Object[]{Product.NAME}));
            return false;
        }
        return true;
    }
}

