/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.stash.internal.user.AvatarSource;
import com.atlassian.stash.user.AvatarRequest;
import com.atlassian.stash.user.Person;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="webResourceAvatarSource")
public class WebResourceAvatarSource
implements AvatarSource {
    public static final String AVATAR_MODULE_KEY = "com.atlassian.stash.stash-web-plugin:avatar";
    public static final String AVATAR_RESOURCE_FORMAT = "avatar/default-avatar-%1$d.png";
    private final WebResourceUrlProvider urlProvider;

    @Autowired
    public WebResourceAvatarSource(WebResourceUrlProvider urlProvider) {
        this.urlProvider = urlProvider;
    }

    @Nonnull
    public String getAvatarUrl(@Nonnull Person person, @Nonnull AvatarRequest request) {
        int size = ((AvatarRequest)Preconditions.checkNotNull((Object)request)).getSize();
        size = size > 48 ? 128 : (size > 32 ? 48 : (size > 16 ? 32 : 16));
        String resourceName = String.format(AVATAR_RESOURCE_FORMAT, size);
        return this.urlProvider.getStaticPluginResourceUrl(AVATAR_MODULE_KEY, resourceName, UrlMode.ABSOLUTE);
    }
}

