/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserCreatedEvent;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.event.api.EventListener;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserCreatedAttributeBootstrapper
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(UserCreatedAttributeBootstrapper.class);
    private CrowdService crowdService;

    @Autowired
    public UserCreatedAttributeBootstrapper(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @EventListener
    @Transactional
    public void handleEvent(UserCreatedEvent event) {
        try {
            this.crowdService.setUserAttribute((User)event.getUser(), "failedAuthenticationAttemptCount", Long.toString(0L));
        }
        catch (OperationNotPermittedException e) {
            LOG.error(String.format("Unable to initialise the %s attribute for user %s", "failedAuthenticationAttemptCount", event.getUser().getName()));
        }
    }
}

