/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.StashAuthenticationToken;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class StashAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    public static final String CAPTCHA = "captcha";
    private boolean postOnly = true;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        String captchaResponse = request.getParameter(CAPTCHA);
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        if (captchaResponse == null) {
            captchaResponse = "";
        }
        username = username.trim();
        StashAuthenticationToken authRequest = new StashAuthenticationToken(username, password, request.getRequestedSessionId(), captchaResponse);
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }
}

