/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.context.HttpRequestResponseHolder;
import org.springframework.security.web.context.SecurityContextRepository;

public class SecurityContextRepositoryImpl
implements SecurityContextRepository {
    public static final String STASH_SECURITY_CONTEXT_KEY = "STASH_SECURITY_CONTEXT";
    private final UserService userService;

    public SecurityContextRepositoryImpl(UserService userService) {
        this.userService = userService;
    }

    public void saveContext(SecurityContext context, HttpServletRequest request, HttpServletResponse response) {
        HttpSession httpSession;
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            HttpSession httpSession2 = request.getSession(false);
            if (httpSession2 != null) {
                httpSession2.removeAttribute(STASH_SECURITY_CONTEXT_KEY);
            }
        } else if (authentication instanceof StashUserAuthenticationToken && (httpSession = request.getSession(!response.isCommitted())) != null) {
            httpSession.setAttribute(STASH_SECURITY_CONTEXT_KEY, (Object)((StashUserAuthenticationToken)authentication).getId());
        }
    }

    public SecurityContext loadContext(HttpRequestResponseHolder requestResponseHolder) {
        StashUser user;
        HttpServletRequest request = requestResponseHolder.getRequest();
        SecurityContextImpl securityContext = new SecurityContextImpl();
        Integer authenticationId = this.getAuthenticationId(request);
        if (authenticationId != null && (user = this.userService.getUser(authenticationId)) != null && user.isActive()) {
            StashUserAuthenticationToken authentication = new StashUserAuthenticationToken(user);
            securityContext.setAuthentication((Authentication)authentication);
        }
        return securityContext;
    }

    private Integer getAuthenticationId(HttpServletRequest request) {
        Object idFromSession;
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (idFromSession = httpSession.getAttribute(STASH_SECURITY_CONTEXT_KEY)) instanceof Integer) {
            return (Integer)idFromSession;
        }
        return null;
    }

    public boolean containsContext(HttpServletRequest request) {
        return this.getAuthenticationId(request) != null;
    }
}

