/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.PermissionService;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionPredicateFactoryImpl
implements PermissionPredicateFactory {
    private final PermissionService permissionService;

    @Autowired
    public PermissionPredicateFactoryImpl(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public Predicate<Project> createProjectPermissionPredicate(final @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return new Predicate<Project>(){

            public boolean apply(Project project) {
                Preconditions.checkNotNull((Object)project);
                return PermissionPredicateFactoryImpl.this.permissionService.hasProjectPermission(project, permission);
            }
        };
    }

    public Predicate<Repository> createRepositoryPermissionPredicate(final @Nonnull Permission permission) {
        Preconditions.checkArgument((!permission.isGlobal() ? 1 : 0) != 0);
        return new Predicate<Repository>(){

            public boolean apply(Repository repository) {
                Preconditions.checkNotNull((Object)repository);
                return PermissionPredicateFactoryImpl.this.permissionService.hasRepositoryPermission(repository, permission);
            }
        };
    }
}

