/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageFilter;
import com.atlassian.stash.util.PredicatePageFilter;
import com.google.common.base.Predicate;
import java.util.SortedMap;
import java.util.regex.Pattern;

public class GroupMatchFilter
extends PageFilter<String> {
    private PredicatePageFilter<String> predicateFilter;

    public GroupMatchFilter(String usernamePattern) {
        final Pattern pattern = usernamePattern == null ? null : Pattern.compile("(\\b|^|[^\\p{L}\\p{N}])" + Pattern.quote(usernamePattern), 2);
        this.predicateFilter = new PredicatePageFilter((Predicate)new Predicate<String>(){

            public boolean apply(String groupName) {
                return pattern == null || pattern.matcher(groupName).find();
            }
        });
    }

    public SortedMap<Integer, String> apply(int limit, Page<? extends String> internalPage) {
        return this.predicateFilter.apply(limit, internalPage);
    }
}

