/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class ExtendedWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    private final PermissionService permissionService;

    public ExtendedWebSecurityExpressionRoot(Authentication a, FilterInvocation fi, PermissionService permissionService) {
        super(a, fi);
        this.permissionService = permissionService;
    }

    public boolean hasGlobalPermission(String permission) {
        Permission requestedPerm = Permission.valueOf((String)permission);
        Preconditions.checkArgument((boolean)requestedPerm.isGlobal());
        return this.permissionService.hasGlobalPermission((StashUser)this.resolveAuthenticationToken(), requestedPerm);
    }

    private StashUserAuthenticationToken resolveAuthenticationToken() {
        if (this.authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)this.authentication;
        }
        return null;
    }
}

