/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionService;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import org.springframework.security.access.expression.method.PublicMethodSecurityExpressionRoot;
import org.springframework.security.core.Authentication;

public class ExtendedMethodSecurityExpressionRoot
extends PublicMethodSecurityExpressionRoot {
    private final ThreadLocal<Boolean> permissionLoopGuard;
    private PermissionService permissionService;
    private Object returnObject;

    public ExtendedMethodSecurityExpressionRoot(Authentication a, ThreadLocal<Boolean> evaluationPermissions) {
        super(a);
        this.permissionLoopGuard = evaluationPermissions;
    }

    private void enterPermissionCheck() {
        if (this.permissionLoopGuard.get() != null) {
            throw new IllegalStateException("Nested method authorisation check detected. This would have led to an infinite loop!");
        }
        this.permissionLoopGuard.set(Boolean.TRUE);
    }

    private void exitPermissionCheck() {
        this.permissionLoopGuard.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGlobalPermission(Object permission) {
        this.enterPermissionCheck();
        try {
            Permission requestedPermission = Permission.valueOf((String)String.valueOf(permission));
            Preconditions.checkArgument((boolean)requestedPermission.isGlobal());
            boolean bl = this.permissionService.hasGlobalPermission(requestedPermission);
            return bl;
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    public boolean hasGlobalPermission(Object user, Object permission) {
        this.enterPermissionCheck();
        try {
            Permission requestedPermission = Permission.valueOf((String)String.valueOf(permission));
            Preconditions.checkArgument((boolean)requestedPermission.isGlobal());
            if (user instanceof Integer) {
                throw new UnsupportedOperationException();
            }
            if (user instanceof String) {
                boolean bl = this.permissionService.hasGlobalPermission((String)user, requestedPermission);
                return bl;
            }
            if (user instanceof StashUser) {
                boolean bl = this.permissionService.hasGlobalPermission((StashUser)user, requestedPermission);
                return bl;
            }
            throw new IllegalArgumentException();
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyPermission(Object permission) {
        this.enterPermissionCheck();
        try {
            Permission requestedPermission = Permission.valueOf((String)String.valueOf(permission));
            boolean bl = this.permissionService.hasAnyUserPermission(requestedPermission);
            return bl;
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    public boolean hasProjectPermission(Object proj, Object permission) {
        this.enterPermissionCheck();
        try {
            Permission requestedPermission = Permission.valueOf((String)String.valueOf(permission));
            Preconditions.checkArgument((!requestedPermission.isGlobal() ? 1 : 0) != 0);
            if (proj == null) {
                boolean bl = true;
                return bl;
            }
            if (proj instanceof Project) {
                boolean bl = this.permissionService.hasProjectPermission((StashUser)this.resolveUser(), (Project)proj, requestedPermission);
                return bl;
            }
            if (proj instanceof Integer) {
                boolean bl = this.permissionService.hasProjectPermission((StashUser)this.resolveUser(), (Integer)proj, requestedPermission);
                return bl;
            }
            throw new IllegalArgumentException("Permission check on invalid type '" + proj.getClass().getName() + "'");
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    public boolean hasRepositoryPermission(Object repository, Object permission) {
        this.enterPermissionCheck();
        try {
            Permission requested = Permission.valueOf((String)String.valueOf(permission));
            Preconditions.checkArgument((!requested.isGlobal() ? 1 : 0) != 0);
            if (repository == null) {
                boolean bl = true;
                return bl;
            }
            if (repository instanceof Repository) {
                boolean bl = this.permissionService.hasRepositoryPermission((StashUser)this.resolveUser(), (Repository)repository, requested);
                return bl;
            }
            if (repository instanceof Integer) {
                boolean bl = this.permissionService.hasRepositoryPermission((StashUser)this.resolveUser(), (Integer)repository, requested);
                return bl;
            }
            throw new IllegalArgumentException("Permission check on invalid type '" + repository.getClass().getName() + "'");
        }
        finally {
            this.exitPermissionCheck();
        }
    }

    public boolean isCurrentUser(StashUser user) {
        return user != null && this.isCurrentUser(user.getName());
    }

    public boolean isCurrentUser(String username) {
        StashUserAuthenticationToken user = this.resolveUser();
        if (user == null || user.getName() == null) {
            return false;
        }
        return user.getName().equals(username);
    }

    private StashUserAuthenticationToken resolveUser() {
        if (this.authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)this.authentication;
        }
        return null;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }
}

