/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.AvatarSource;
import com.atlassian.stash.internal.user.InternalAvatarService;
import com.atlassian.stash.user.AvatarRequest;
import com.atlassian.stash.user.AvatarService;
import com.atlassian.stash.user.Person;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AvatarService.class)
@Service(value="avatarService")
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private final AtomicReference<AvatarSource> activeSource;
    private final AvatarSource defaultSource;
    private final AvatarSource disabledSource;
    private final InternalApplicationPropertiesService propertiesService;

    @Autowired
    public ConfigurableAvatarService(InternalApplicationPropertiesService propertiesService, @Qualifier(value="gravatarAvatarSource") AvatarSource defaultSource, @Qualifier(value="webResourceAvatarSource") AvatarSource disabledSource) {
        this.defaultSource = defaultSource;
        this.disabledSource = disabledSource;
        this.propertiesService = propertiesService;
        this.activeSource = DISABLED_SOURCE.equals(propertiesService.getAvatarSource()) ? new AtomicReference<AvatarSource>(disabledSource) : new AtomicReference<AvatarSource>(defaultSource);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getAvatarUrl(@Nonnull Person person, @Nonnull AvatarRequest request) {
        return this.activeSource.get().getAvatarUrl(person, request);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        if (enabled) {
            this.activeSource.compareAndSet(this.disabledSource, this.defaultSource);
        } else {
            this.activeSource.compareAndSet(this.defaultSource, this.disabledSource);
        }
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }
}

