/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.stash.exception.AuthenticationFailedException;
import com.atlassian.stash.exception.OperationFailedException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.user.BadCaptchaException;
import com.atlassian.stash.internal.user.BadStashCredentialsException;
import com.atlassian.stash.internal.user.OperationFailedAuthenticaionException;
import com.atlassian.stash.internal.user.StashAuthenticationToken;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.atlassian.stash.license.LicenseService;
import com.atlassian.stash.user.CaptchaAuthenticationException;
import com.atlassian.stash.user.CaptchaResponse;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.user.UserService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component(value="authenticationProvider")
public class AuthenticationProviderImpl
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationProviderImpl.class);
    private final UserService userService;
    private final LicenseService licenseService;
    private final I18nService i18nService;

    @Autowired
    public AuthenticationProviderImpl(UserService userService, LicenseService licenseService, I18nService i18nService) {
        this.userService = userService;
        this.licenseService = licenseService;
        this.i18nService = i18nService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            if (this.isNonEmptyString(authentication.getPrincipal()) && this.isNullOrString(authentication.getCredentials())) {
                String username = (String)authentication.getPrincipal();
                String credentials = (String)authentication.getCredentials();
                credentials = credentials == null ? "" : credentials;
                try {
                    CaptchaResponse captchaResponse = this.extractCaptchaResponseFromAuth(authentication);
                    StashUser user = this.userService.authenticate(username, credentials, captchaResponse);
                    if (!this.licenseService.isUserLicensed(user)) {
                        throw new DisabledException("User does not have permission to access this system");
                    }
                    return new StashUserAuthenticationToken(user);
                }
                catch (CaptchaAuthenticationException e) {
                    throw new BadCaptchaException(this.reauthWithWebappMessage((Exception)((Object)e), authentication));
                }
                catch (AuthenticationFailedException e) {
                    String message = this.reauthWithWebappMessage((Exception)((Object)e), authentication);
                    throw new BadStashCredentialsException(message, e.captchaRequired());
                }
                catch (OperationFailedException e) {
                    throw new OperationFailedAuthenticaionException(e.getMessage());
                }
            }
            throw new BadStashCredentialsException(this.i18nService.getText("stash.web.auth.failed", "Invalid username or password", new Object[0]));
        }
        return null;
    }

    private CaptchaResponse extractCaptchaResponseFromAuth(Authentication authentication) {
        return authentication instanceof StashAuthenticationToken ? this.extractCaptchaResponse((StashAuthenticationToken)authentication) : null;
    }

    private CaptchaResponse extractCaptchaResponse(StashAuthenticationToken token) {
        String challengeId = token.getCaptchaChallengeId();
        String userResponse = token.getCaptchaResponse();
        return StringUtils.isNotEmpty((String)challengeId) && StringUtils.isNotEmpty((String)userResponse) ? new CaptchaResponse(challengeId, userResponse) : null;
    }

    private String reauthWithWebappMessage(Exception e, Authentication authentication) {
        return authentication instanceof StashAuthenticationToken ? e.getMessage() : this.i18nService.getText("stash.auth.failed.captcha.required", "To proceed you must first re-authenticate with Stash via the web interface", new Object[0]);
    }

    private boolean isNonEmptyString(Object object) {
        return object instanceof String && StringUtils.isNotEmpty((String)((String)object));
    }

    private boolean isNullOrString(Object object) {
        return object == null || object instanceof String;
    }

    public boolean supports(Class<?> aClass) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(aClass);
    }
}

