/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.event.BaseUrlChangedEvent;
import com.atlassian.stash.event.DisplayNameChangedEvent;
import com.atlassian.stash.event.LicenseChangedEvent;
import com.atlassian.stash.event.MailHostConfigurationChangedEvent;
import com.atlassian.stash.event.ServerEmailAddressChangedEvent;
import com.atlassian.stash.exception.InvalidLicenseException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.server.ApplicationPropertiesDao;
import com.atlassian.stash.internal.server.ApplicationProperty;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.mail.MailHostConfiguration;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.atlassian.stash.util.NumberUtils;
import com.atlassian.stash.util.UrlUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=ApplicationPropertiesService.class)
@Component
public class ApplicationPropertiesServiceImpl
extends AbstractService
implements InternalApplicationPropertiesService {
    private final ApplicationSettings settings;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationPropertiesDao propertiesDao;
    private final String jdbcDriver;
    private final String jdbcUrl;
    private final Properties properties;

    @Autowired
    public ApplicationPropertiesServiceImpl(ApplicationSettings settings, ApplicationPropertiesDao propertiesDao, EventPublisher eventPublisher, I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties, @Value(value="${jdbc.driver}") String jdbcDriver, @Value(value="${jdbc.url}") String jdbcUrl) {
        this.settings = settings;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.propertiesDao = propertiesDao;
        this.properties = properties;
        this.jdbcDriver = jdbcDriver;
        this.jdbcUrl = jdbcUrl;
    }

    public String getAvatarSource() {
        return this.getProperty(ApplicationProperty.Key.AVATAR_SOURCE);
    }

    public URI getLoginUri(URI redirectUri) {
        String loginUri = this.getBaseUrl() + "/login?next=" + UrlUtils.encodeURL((String)redirectUri.toString());
        return UrlUtils.uncheckedCreateURI((String)loginUri);
    }

    public URI getBaseUrl() {
        return UrlUtils.uncheckedCreateURI((String)this.getProperty(ApplicationProperty.Key.BASE_URL));
    }

    public String getDisplayName() {
        return this.getProperty(ApplicationProperty.Key.NAME);
    }

    public String getServerEmailAddress() {
        return this.getProperty(ApplicationProperty.Key.EMAIL_ADDRESS);
    }

    public String getLicense() {
        return this.getProperty(ApplicationProperty.Key.LICENSE);
    }

    public boolean isAllowPublicSignUp() {
        return Boolean.valueOf(this.getProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP));
    }

    public boolean isShowCaptchaOnSignUp() {
        return Boolean.valueOf(this.getProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP));
    }

    public boolean isSetup() {
        return Boolean.valueOf(this.getProperty(ApplicationProperty.Key.SETUP_COMPLETED));
    }

    public int getMaxCaptchaAttempts() {
        return NumberUtils.parse((String)this.getProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS), (Integer)5, (String)"Configured max captcha attempts is not a number. Using default!");
    }

    public String getBuildVersion() {
        return this.settings.getBuildVersion();
    }

    public Date getBuildTimestamp() {
        return this.settings.getBuildTimestamp();
    }

    public String getBuildNumber() {
        return this.settings.getBuildNumber();
    }

    public File getCacheDir() {
        return this.settings.getCacheDir();
    }

    public String getCommitHash() {
        return this.settings.getCommitHash();
    }

    public File getConfigDir() {
        return this.settings.getConfigDir();
    }

    public File getHomeDir() {
        return this.settings.getHomeDir();
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public File getRepositoriesDir() {
        return this.settings.getRepositoriesDir();
    }

    public File getRepositoryDirectory(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        File root = this.getRepositoriesDir();
        String name = String.valueOf(repository.getId());
        return new File(root, name);
    }

    public TimeZone getDefaultTimeZone() {
        return TimeZone.getDefault();
    }

    @Transactional(readOnly=true)
    public MailHostConfiguration getMailHostConfiguration() {
        MailHostConfiguration config = new MailHostConfiguration.Builder().hostname(this.getProperty(ApplicationProperty.Key.MAIL_HOST)).port(NumberUtils.parse((String)this.getProperty(ApplicationProperty.Key.MAIL_HOST_PORT), (String)"Configured mail host port is not a number. Using default!")).useTls(Boolean.parseBoolean(this.getProperty(ApplicationProperty.Key.MAIL_USE_TLS))).username(this.getProperty(ApplicationProperty.Key.MAIL_HOST_USERNAME)).password(this.getProperty(ApplicationProperty.Key.MAIL_HOST_PASSWORD)).build();
        return config.getHostname() == null && config.getPort() == null && config.getUsername() == null ? null : config;
    }

    public String getServerId() {
        return this.getProperty(ApplicationProperty.Key.SERVER_ID);
    }

    private String getProperty(ApplicationProperty.Key key) {
        ApplicationProperty property = (ApplicationProperty)this.propertiesDao.getById((Object)key);
        return property == null ? null : property.getValue();
    }

    private String deleteOrUpdate(ApplicationProperty.Key key, @Nullable Object newValue) {
        ApplicationProperty property = (ApplicationProperty)this.propertiesDao.getById((Object)key);
        if (newValue == null) {
            if (property != null) {
                this.propertiesDao.delete((Object)property);
            }
        } else {
            this.propertiesDao.update((Object)new ApplicationProperty(key, newValue.toString()));
        }
        return property == null ? null : property.getValue();
    }

    private void delete(ApplicationProperty.Key ... keys) {
        for (ApplicationProperty.Key key : keys) {
            this.deleteOrUpdate(key, null);
        }
    }

    private String updateProperty(ApplicationProperty.Key key, @Nonnull String newValue) {
        Preconditions.checkNotNull((Object)newValue);
        return this.deleteOrUpdate(key, newValue);
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    @Transactional
    public void setAvatarSource(String avatarSource) {
        this.updateProperty(ApplicationProperty.Key.AVATAR_SOURCE, avatarSource);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setDisplayName(String displayName) {
        String oldValue = this.updateProperty(ApplicationProperty.Key.NAME, displayName);
        this.eventPublisher.publish((Object)new DisplayNameChangedEvent((Object)this, oldValue, displayName));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setLicense(String license) {
        if (license == null) {
            throw new InvalidLicenseException(this.i18nService.getKeyedText("stash.license.unremovable", "Once configured, a license may not be removed", new Object[0]));
        }
        this.updateProperty(ApplicationProperty.Key.LICENSE, license);
        this.eventPublisher.publish((Object)new LicenseChangedEvent((Object)this));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setBaseURL(String baseUrl) {
        Preconditions.checkNotNull((Object)baseUrl);
        baseUrl = StringUtils.removeEnd((String)baseUrl, (String)"/");
        String oldValue = this.updateProperty(ApplicationProperty.Key.BASE_URL, baseUrl);
        this.eventPublisher.publish((Object)new BaseUrlChangedEvent((Object)this, oldValue, baseUrl));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setServerEmailAddress(String emailAddress) {
        String oldValue = this.updateProperty(ApplicationProperty.Key.EMAIL_ADDRESS, emailAddress);
        this.eventPublisher.publish((Object)new ServerEmailAddressChangedEvent((Object)this, oldValue, emailAddress));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setAllowPublicSignUp(boolean publicSignUp) {
        this.updateProperty(ApplicationProperty.Key.ALLOW_PUBLIC_SIGNUP, Boolean.toString(publicSignUp));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setShowCaptchaOnSignUp(boolean captchaOnSignUp) {
        this.updateProperty(ApplicationProperty.Key.REQUIRE_CAPTCHA_ON_SIGNUP, Boolean.toString(captchaOnSignUp));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    public void setSetup(boolean setup) {
        this.updateProperty(ApplicationProperty.Key.SETUP_COMPLETED, Boolean.toString(setup));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setMaxCaptchaAttempts(int maxCaptchaAttempts) {
        this.updateProperty(ApplicationProperty.Key.MAX_CAPTCHA_ATTEMPTS, Integer.toString(maxCaptchaAttempts));
    }

    @PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
    @Transactional
    public void setServerId(String serverId) {
        this.updateProperty(ApplicationProperty.Key.SERVER_ID, serverId);
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setMailHostConfiguration(MailHostConfiguration mailHostConfiguration) {
        MailHostConfiguration oldValue = this.getMailHostConfiguration();
        if (mailHostConfiguration == null) {
            this.delete(ApplicationProperty.Key.MAIL_HOST, ApplicationProperty.Key.MAIL_HOST_PORT, ApplicationProperty.Key.MAIL_HOST_USERNAME, ApplicationProperty.Key.MAIL_HOST_PASSWORD, ApplicationProperty.Key.MAIL_USE_TLS);
        } else {
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST, mailHostConfiguration.getHostname());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PORT, mailHostConfiguration.getPort());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_USERNAME, mailHostConfiguration.getUsername());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_HOST_PASSWORD, mailHostConfiguration.getPassword());
            this.deleteOrUpdate(ApplicationProperty.Key.MAIL_USE_TLS, mailHostConfiguration.isUseTls());
        }
        this.eventPublisher.publish((Object)new MailHostConfigurationChangedEvent((Object)this, oldValue, mailHostConfiguration));
    }

    @Transactional
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void deleteMailHostConfiguration() {
        this.setMailHostConfiguration(null);
    }

    public String getPluginProperty(String propertyName) {
        this.validatePropertyName(propertyName);
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(propertyName);
    }

    public String getPluginProperty(String propertyName, String defaultValue) {
        this.validatePropertyName(propertyName);
        if (this.properties == null) {
            return defaultValue;
        }
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public int getPluginProperty(String propertyName, int defaultValue) throws NumberFormatException {
        String value = this.getPluginProperty(propertyName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public long getPluginProperty(String propertyName, long defaultValue) throws NumberFormatException {
        String value = this.getPluginProperty(propertyName);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    public boolean getPluginProperty(String propertyName, boolean defaultValue) {
        String value = this.getPluginProperty(propertyName);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    private void validatePropertyName(String propertyName) {
        Preconditions.checkArgument((propertyName != null ? 1 : 0) != 0, (Object)"Property name must not be null");
        Preconditions.checkArgument((boolean)propertyName.startsWith("plugin."), (Object)("Property name \"" + propertyName + "\" does not start with \"plugin.\""));
    }
}

