/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.event.RepositoryCreatedEvent;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.repository.RepositoryStateManager;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.repository.Repository;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="repositoryStateManager")
@PreAuthorize(value="hasRepositoryPermission(#repository, 'REPO_ADMIN')")
@Transactional
public class RepositoryStateManagerImpl
implements RepositoryStateManager {
    private final RepositoryDao repositoryDao;
    private final EventPublisher eventPublisher;

    @Autowired
    public RepositoryStateManagerImpl(RepositoryDao repositoryDao, EventPublisher publisher) {
        this.repositoryDao = repositoryDao;
        this.eventPublisher = publisher;
    }

    @Override
    public void setRepositoryState(Repository repository, Repository.State state, String stateMessage) {
        InternalRepository internalRepository = InternalConverter.convertToInternalRepository(repository);
        InternalRepository updatedRepo = internalRepository.copy().state(state).statusMessage(stateMessage).build();
        updatedRepo = (InternalRepository)this.repositoryDao.update((Object)updatedRepo);
        if (state == Repository.State.AVAILABLE) {
            this.eventPublisher.publish((Object)new RepositoryCreatedEvent((Object)this, (Repository)updatedRepo));
        }
    }

    @Override
    public void setRepositoryState(Repository repository, Repository.State state) {
        this.setRepositoryState(repository, state, null);
    }

    @Override
    public void deleteRepository(Repository repository) {
        this.repositoryDao.delete((Object)((InternalRepository)repository));
        this.eventPublisher.publish((Object)new RepositoryDeletedEvent((Object)this, repository));
    }

    @Override
    @Nonnull
    public Iterable<Integer> reparentChildRepositories(Repository repository) {
        ArrayList<Integer> childRepositoryIds = new ArrayList<Integer>();
        InternalRepository newOrigin = InternalConverter.convertToInternalRepository(repository.getOrigin());
        for (InternalRepository child : this.repositoryDao.findByOrigin(InternalConverter.convertToInternalRepository(repository))) {
            InternalRepository newChild = child.copy().origin(newOrigin).build();
            childRepositoryIds.add(child.getId());
            this.repositoryDao.update((Object)newChild);
        }
        return childRepositoryIds;
    }
}

