/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.project;

import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.exception.IntegrityException;
import com.atlassian.stash.exception.NoSuchEntityException;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.internal.annotation.Secured;
import com.atlassian.stash.internal.project.InternalProject;
import com.atlassian.stash.internal.project.ProjectDao;
import com.atlassian.stash.internal.user.GrantedPermissionDao;
import com.atlassian.stash.internal.user.InternalConverter;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.project.Project;
import com.atlassian.stash.project.ProjectService;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionAdminService;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.user.StashAuthenticationContext;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="projectService")
@Transactional(readOnly=true)
@AvailableToPlugins(value=ProjectService.class)
public class ProjectServiceImpl
implements ProjectService {
    private final ProjectDao projectDao;
    private I18nService i18nService;
    private final PermissionAdminService permissionAdminService;
    private final StashAuthenticationContext authenticationContext;
    private final Validator validator;
    private final PermissionPredicateFactory permissionPredicateFactory;
    private final GrantedPermissionDao grantedPermissionDao;
    private int maxProjectPageSize;

    @Autowired
    public ProjectServiceImpl(ProjectDao projectDao, PermissionPredicateFactory permissionPredicateFactory, PermissionAdminService permissionAdminService, StashAuthenticationContext authenticationContext, I18nService i18nService, Validator validator, GrantedPermissionDao grantedPermissionDao) {
        this.projectDao = projectDao;
        this.i18nService = i18nService;
        this.permissionAdminService = permissionAdminService;
        this.authenticationContext = authenticationContext;
        this.validator = validator;
        this.permissionPredicateFactory = permissionPredicateFactory;
        this.grantedPermissionDao = grantedPermissionDao;
    }

    private void validateProject(Project project, Class<?> ... groups) {
        HashSet validationErrors = new HashSet();
        validationErrors.addAll(this.validator.validate((Object)project, (Class[])groups));
        if (!validationErrors.isEmpty()) {
            throw new ConstraintViolationException(validationErrors);
        }
    }

    @Autowired
    public void setMaxProjectPageSize(@Value(value="${page.max.projects}") int maxProjectPageSize) {
        this.maxProjectPageSize = maxProjectPageSize;
    }

    @Nonnull
    @Transactional
    @PreAuthorize(value="hasGlobalPermission('PROJECT_CREATE')")
    public Project create(@Nonnull String projectKey, @Nonnull String name, String description) {
        InternalProject project = new InternalProject.Builder().key(projectKey).name(name).description(description).build();
        this.validateProject((Project)project, new Class[0]);
        project = (InternalProject)this.projectDao.create((Object)project);
        InternalGrantedPermission perm = new InternalGrantedPermission(Permission.PROJECT_ADMIN, project, null, InternalConverter.convertToInternalUser(this.authenticationContext.getCurrentUser()), false);
        this.grantedPermissionDao.create((Object)perm);
        return project;
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#project.id, 'PROJECT_ADMIN')")
    public boolean delete(Project project) {
        InternalProject internalProject = (InternalProject)this.projectDao.getById((Object)project.getId());
        if (internalProject != null) {
            if (this.projectDao.hasRepositories(internalProject.getId().intValue())) {
                KeyedMessage message = this.i18nService.getKeyedText("stash.service.project.deletionintegrity", "The project \"{0}\" cannot be deleted because it has repositories.", new Object[]{internalProject.getKey()});
                throw new IntegrityException(message);
            }
            this.permissionAdminService.revokeAllProjectPermissions((Project)internalProject);
            this.projectDao.delete((Object)internalProject);
            return true;
        }
        return false;
    }

    @Nonnull
    @Secured(value="Secured using a predicate for Permission.PROJECT_READ")
    public Page<? extends Project> findAll(@Nonnull PageRequest pageRequest) {
        PageRequest restrictedPageRequest = pageRequest.buildRestrictedPageRequest(this.maxProjectPageSize);
        return this.projectDao.findAll(restrictedPageRequest, this.permissionPredicateFactory.createProjectPermissionPredicate(Permission.PROJECT_READ));
    }

    @Nonnull
    @Secured(value="Secured using a predicate for Permission.PROJECT_READ")
    public List<String> findAllProjectKeys() {
        Predicate predicate = this.permissionPredicateFactory.createProjectPermissionPredicate(Permission.PROJECT_READ);
        Iterable keys = this.projectDao.findAllKeys(predicate);
        return ImmutableList.builder().addAll(keys).build();
    }

    @Transactional
    @PreAuthorize(value="hasProjectPermission(#id, 'PROJECT_ADMIN')")
    public Project update(int id, @Nonnull String projectKey, @Nonnull String name, String description) {
        InternalProject project = (InternalProject)this.projectDao.getById((Object)id);
        if (project == null) {
            KeyedMessage message = this.i18nService.getKeyedText("stash.service.project.nosuchproject", "No project with key \"{0}\"", new Object[]{projectKey});
            throw new NoSuchEntityException(message);
        }
        project = project.copy().key(projectKey).name(name).description(description).build();
        this.validateProject((Project)project, new Class[0]);
        return (Project)this.projectDao.update((Object)project);
    }

    @PostAuthorize(value="hasProjectPermission(returnObject, 'PROJECT_READ')")
    public Project findByKey(@Nonnull String projectKey) {
        return this.projectDao.findByKey(projectKey);
    }

    @PostAuthorize(value="hasProjectPermission(returnObject, 'PROJECT_READ')")
    public Project findByName(@Nonnull String projectName) {
        return this.projectDao.findByName(projectName);
    }

    @PreAuthorize(value="hasProjectPermission(#id, 'PROJECT_READ')")
    public Project getById(int id) {
        return (Project)this.projectDao.getById((Object)id);
    }
}

