/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.mail;

import com.atlassian.stash.internal.mail.JavaMailSenderFactory;
import com.atlassian.stash.mail.MailHostConfiguration;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Component;

@Component(value="javaMailSenderFactory")
public class DefaultJavaMailSenderFactory
implements JavaMailSenderFactory {
    public static final String SMTP_AUTH = "mail.smtp.auth";
    public static final String SMTP_CONNECTION_TIMEOUT = "mail.smtp.connectiontimeout";
    public static final String SMTP_SEND_TIMEOUT = "mail.smtp.timeout";
    public static final String SMTP_START_TLS = "mail.smtp.starttls.enable";

    public JavaMailSenderImpl create(MailHostConfiguration configuration, int connectTimeout, int sendTimeout) {
        if (configuration == null || StringUtils.isBlank((String)configuration.getHostname())) {
            return null;
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setDefaultEncoding("UTF-8");
        sender.setHost(configuration.getHostname());
        if (configuration.getPort() != null) {
            sender.setPort(configuration.getPort().intValue());
        }
        Properties properties = new Properties();
        if (connectTimeout > 0) {
            properties.setProperty(SMTP_CONNECTION_TIMEOUT, String.valueOf(connectTimeout));
        }
        if (sendTimeout > 0) {
            properties.setProperty(SMTP_SEND_TIMEOUT, String.valueOf(sendTimeout));
        }
        if (StringUtils.isNotBlank((String)configuration.getUsername())) {
            properties.setProperty(SMTP_AUTH, "true");
            sender.setUsername(configuration.getUsername());
            if (StringUtils.isNotBlank((String)configuration.getPassword())) {
                sender.setPassword(configuration.getPassword());
            }
        }
        if (configuration.isUseTls()) {
            properties.setProperty(SMTP_START_TLS, "true");
        }
        sender.setJavaMailProperties(properties);
        return sender;
    }
}

