/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.config.log.LoggingService;
import com.atlassian.stash.event.web.RequestEndedEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.log.EnhancedLevel;
import com.google.common.collect.ImmutableSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=LoggingService.class)
@Service(value="loggingService")
public class LogbackLoggingService
implements LoggingService,
StatefulService {
    public static final String GENERIC_PROPERTY_PREFIX = "logging.logger.";
    public static final String LOG4J_PROPERTY_PREFIX = "log4j.logger.";
    public static final Set<String> PROPERTY_PREFIXES = ImmutableSet.of((Object)"log4j.logger.", (Object)"logging.logger.");
    private final I18nService i18nService;
    private final Properties properties;

    @Autowired
    public LogbackLoggingService(I18nService i18nService, @Qualifier(value="applicationProperties") Properties properties) {
        this.i18nService = i18nService;
        this.properties = properties;
    }

    @PostConstruct
    public void applyLevelProperties() {
        Enumeration<?> propertyNames = this.properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            for (String prefix : PROPERTY_PREFIXES) {
                String levelName;
                if (!propertyName.startsWith(prefix) || (levelName = StringUtils.trimToNull((String)this.properties.getProperty(propertyName))) == null) continue;
                String loggerName = propertyName.substring(prefix.length());
                this.setLevel(loggerName, levelName);
            }
        }
    }

    @Unsecured(value="Retrieving a logger is a trivial operation which is available for any caller in any context")
    public Logger getLogger(String name) {
        return LoggerFactory.getLogger((String)name);
    }

    @Override
    public TransferableState getState() {
        return new MdcState(MDC.getCopyOfContextMap());
    }

    @EventListener
    public void onRequestEnded(RequestEndedEvent event) {
        MDC.clear();
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setLevel(String loggerName, String levelName) {
        Level level = this.toLevel(levelName);
        String name = StringUtils.trimToNull((String)loggerName);
        if (name == null) {
            String message = this.i18nService.getText("stash.logging.logger.name.required", "A logger name must be provided in order to update its level", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = lc.getLogger(name);
        Level effectiveLevel = logger.getEffectiveLevel();
        if (effectiveLevel != level) {
            EnhancedLevel.fromLevel(effectiveLevel).log((Logger)logger, "Switching to log level [{}]", levelName);
            logger.setLevel(level);
        }
    }

    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setRootLevel(String levelName) {
        this.setLevel("ROOT", levelName);
    }

    private Level toLevel(String levelName) {
        Level level = Level.toLevel((String)levelName, null);
        if (level == null) {
            String message = this.i18nService.getText("stash.logging.level.invalid", "Requested level [{0}] is not valid", new Object[]{levelName});
            throw new IllegalArgumentException(message);
        }
        return level;
    }

    private static final class MdcState
    implements TransferableState {
        private final Map<?, ?> state;

        private MdcState(Map<?, ?> state) {
            this.state = state;
        }

        @Override
        public void apply() {
            if (this.state != null) {
                MDC.setContextMap(this.state);
            }
        }

        @Override
        public void remove() {
            MDC.clear();
        }
    }
}

