/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx.impl;

import com.atlassian.event.api.EventListener;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.RefCallback;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.ScmClient;
import com.atlassian.utils.process.IOUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepositorySnapshotServiceImpl
implements RepositorySnapshotService {
    private static final Logger log = LoggerFactory.getLogger(RepositorySnapshotServiceImpl.class);
    private final File snapshotDir;

    @Autowired
    public RepositorySnapshotServiceImpl(ApplicationSettings settings) {
        this.snapshotDir = new File(settings.getCacheDir(), "idx-snapshots");
        this.snapshotDir.mkdirs();
    }

    private File getRepositorySnapshotDir(Repository repository) {
        return new File(this.snapshotDir, repository.getId().toString());
    }

    private File getSnapshotFile(Repository repository, Date date) {
        File repositorySnapshotDir = this.getRepositorySnapshotDir(repository);
        repositorySnapshotDir.mkdirs();
        return new File(repositorySnapshotDir, Long.toString(date.getTime()));
    }

    @Override
    public void createRepositorySnapshot(Repository repo, ScmClient client, Date date) throws IOException {
        final FileWriter writer = new FileWriter(this.getSnapshotFile(repo, date));
        try {
            client.getHeadsCommand(repo, new RefCallback(){

                public void onRef(Ref ref) {
                    try {
                        writer.write(ref.getLatestChangeset() + "\n");
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }).call();
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
        finally {
            IOUtils.closeQuietly((Closeable)writer);
        }
    }

    @EventListener
    public void onDeleteRepository(RepositoryDeletedEvent event) {
        try {
            this.deleteSnapshots(event.getRepository());
        }
        catch (IOException e) {
            log.info("There was a problem deleting the snapshots directory for repository " + event.getRepository().getName() + ": " + e.getMessage());
        }
    }

    @Override
    public Iterable<String> getRepositorySnapshot(Repository repo, Date date) {
        if (date != null) {
            return new RepositorySnapshotIterable(this.getSnapshotFile(repo, date));
        }
        return Collections.emptySet();
    }

    @Override
    public void deleteSnapshots(Repository repository) throws IOException {
        FileUtils.deleteDirectory((File)this.getRepositorySnapshotDir(repository));
    }

    private static class RepositorySnapshotIterable
    implements Iterable<String> {
        private File file;

        public RepositorySnapshotIterable(File file) {
            this.file = file;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                private static final int PAGE_SIZE = 100;
                private Deque<String> nextValues = new LinkedList<String>();
                private int offset = 0;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void readPage() {
                    BufferedReader reader = null;
                    try {
                        int lineNumber;
                        reader = new BufferedReader(new FileReader(RepositorySnapshotIterable.this.file));
                        for (lineNumber = 0; lineNumber < this.offset; ++lineNumber) {
                            reader.readLine();
                        }
                        String line = null;
                        int lastLine = this.offset + 100;
                        while (lineNumber < lastLine && (line = reader.readLine()) != null) {
                            this.nextValues.addLast(line);
                            ++lineNumber;
                        }
                        this.offset = line != null ? lastLine : -1;
                        if (reader == null) return;
                    }
                    catch (IOException e) {
                        try {
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            if (reader == null) throw throwable;
                            IOUtils.closeQuietly(reader);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)reader);
                    return;
                }

                @Override
                public boolean hasNext() {
                    if (this.nextValues.isEmpty() && this.offset >= 0) {
                        this.readPage();
                    }
                    return !this.nextValues.isEmpty();
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        return this.nextValues.poll();
                    }
                    throw new NoSuchElementException("No more entries are available");
                }

                @Override
                public void remove() {
                    throw new NotImplementedException();
                }
            };
        }
    }
}

