/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx.impl;

import com.atlassian.stash.internal.idx.ChangesetIndexingService;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesetIndexingJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ChangesetIndexingJob.class);
    protected final ChangesetIndexingService indexingService;
    protected final Repository repository;

    public ChangesetIndexingJob(@Nonnull Repository repository, @Nonnull ChangesetIndexingService indexingService) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.indexingService = (ChangesetIndexingService)Preconditions.checkNotNull((Object)indexingService);
    }

    @Override
    public void run() {
        try {
            this.indexingService.indexRepository(this.repository);
        }
        catch (RuntimeException e) {
            if (this.indexingService.isActive()) {
                log.error("Error during indexing of " + this.repository.getName(), (Throwable)e);
            }
            log.info("Indexing of " + this.repository.getName() + " was aborted.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangesetIndexingJob)) {
            return false;
        }
        ChangesetIndexingJob that = (ChangesetIndexingJob)o;
        return this.repository.equals(that.repository);
    }

    public int hashCode() {
        return this.repository.hashCode();
    }

    public String toString() {
        return "ChangesetIndexingJob " + this.repository.getSlug();
    }
}

