/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.stash.idx.ChangesetAttributeConfiguration;
import com.atlassian.stash.idx.ChangesetAttributeConfigurationModuleDescriptor;
import com.atlassian.stash.repository.Repository;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluggableChangesetAttributeConfiguration
implements ChangesetAttributeConfiguration {
    private final PluginModuleTracker<ChangesetAttributeConfiguration, ChangesetAttributeConfigurationModuleDescriptor> moduleTracker;

    @Autowired
    public PluggableChangesetAttributeConfiguration(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.moduleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, ChangesetAttributeConfigurationModuleDescriptor.class);
    }

    public Collection<String> getAttributesToPreload(Repository repository) {
        HashSet attributes = Sets.newHashSet();
        for (ChangesetAttributeConfiguration handler : this.moduleTracker.getModules()) {
            attributes.addAll(handler.getAttributesToPreload(repository));
        }
        return attributes;
    }
}

