/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.content.AttributeMap;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.event.RepositoryDeletedEvent;
import com.atlassian.stash.idx.ChangesetIndex;
import com.atlassian.stash.idx.IndexedChangeset;
import com.atlassian.stash.internal.content.ChangesetDao;
import com.atlassian.stash.internal.idx.InternalIndexedChangeset;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.user.Permission;
import com.atlassian.stash.user.PermissionPredicateFactory;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageRequest;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="changesetIndex")
@AvailableToPlugins(value=ChangesetIndex.class)
@Transactional
public class DbChangesetIndex
implements ChangesetIndex {
    private final ChangesetDao changesetDao;
    private final Predicate<Repository> canReadRepositoryPredicate;
    @Value(value="${page.max.index.results}")
    private int maxIndexResults;

    @Autowired
    public DbChangesetIndex(ChangesetDao changesetDao, PermissionPredicateFactory predicateFactory) {
        this.changesetDao = changesetDao;
        this.canReadRepositoryPredicate = predicateFactory.createRepositoryPermissionPredicate(Permission.REPO_READ);
    }

    public IndexedChangeset getChangeset(@Nonnull String csid) {
        Preconditions.checkNotNull((Object)csid, (Object)"changesetId cannot be null");
        IndexedChangeset cs = (IndexedChangeset)this.changesetDao.getById((Object)csid);
        if (cs != null && Iterables.any((Iterable)cs.getRepositories(), this.canReadRepositoryPredicate)) {
            return cs;
        }
        return null;
    }

    public boolean isMemberOf(@Nonnull String changesetId, Repository repository) {
        return this.canReadRepositoryPredicate.apply((Object)repository) && this.changesetDao.isMemberOf(changesetId, this.toInternal(repository));
    }

    public void addChangeset(@Nonnull Changeset changeset, @Nonnull Repository repository) {
        InternalIndexedChangeset cs = (InternalIndexedChangeset)this.changesetDao.getById((Object)changeset.getId());
        if (cs == null) {
            cs = new InternalIndexedChangeset(changeset.getId(), changeset.getAuthorTimestamp());
            this.changesetDao.create((Object)cs);
        }
        this.changesetDao.addMembership(cs, this.toInternal(repository));
    }

    public void removeChangeset(@Nonnull String csid, @Nonnull Repository repository) {
        this.changesetDao.deleteMembership(csid, this.toInternal(repository));
    }

    public void addAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        this.changesetDao.addAttribute((InternalIndexedChangeset)this.changesetDao.getById((Object)csid), name, value);
    }

    public void removeAttribute(@Nonnull String csid, @Nonnull String name, @Nonnull String value) {
        this.changesetDao.removeAttribute(csid, name, value);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public Page<IndexedChangeset> findChangesetsByAttribute(@Nonnull String attributeName, @Nonnull String attributeValue, boolean caseSensitive, @Nonnull PageRequest pageRequest) {
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxIndexResults);
        List changesets = this.changesetDao.findByAttribute(attributeName, attributeValue, caseSensitive);
        ArrayList<IndexedChangeset> result = new ArrayList<IndexedChangeset>();
        Iterator it = changesets.iterator();
        int pageEndIndex = pageRequest.getStart() + pageRequest.getLimit();
        int index = 0;
        while (index <= pageEndIndex && it.hasNext()) {
            IndexedChangeset changeset = this.transformForPermissions((InternalIndexedChangeset)it.next());
            if (changeset.getRepositories().isEmpty()) continue;
            if (index >= pageRequest.getStart()) {
                result.add(changeset);
            }
            ++index;
        }
        return PageUtils.createPage(result, (PageRequest)pageRequest);
    }

    @Transactional(readOnly=true)
    @Nonnull
    public AttributeMap getAttributeValues(@Nonnull String csid, @Nonnull Collection<String> attributeNames) {
        return this.changesetDao.getAttributesForChangeset(csid, attributeNames);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public Map<String, AttributeMap> getAttributeValues(@Nonnull Collection<String> csids, @Nonnull Collection<String> attributeNames) {
        return this.changesetDao.getAttributesForChangesets(csids, attributeNames);
    }

    @EventListener
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void onRepositoryDelete(RepositoryDeletedEvent event) {
        this.changesetDao.deleteAllMemberships(this.toInternal(event.getRepository()));
    }

    private IndexedChangeset transformForPermissions(final InternalIndexedChangeset changeset) {
        return new IndexedChangeset(){
            private Set<Repository> visibleRepositories;
            {
                this.visibleRepositories = Sets.newHashSet((Iterable)Sets.filter((Set)changeset.getRepositories(), (Predicate)DbChangesetIndex.this.canReadRepositoryPredicate));
            }

            public String getId() {
                return changeset.getId();
            }

            public Date getAuthorTimestamp() {
                return changeset.getAuthorTimestamp();
            }

            public Set<Repository> getRepositories() {
                return this.visibleRepositories;
            }
        };
    }

    private InternalRepository toInternal(Repository repository) {
        return (InternalRepository)repository;
    }
}

