/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.i18n;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nServiceImpl
implements I18nService {
    private final Map<Plugin, Iterable<String>> pluginResourceBundleNames = CopyOnWriteMap.builder().newHashMap();

    public String getText(String key, String fallbackMessage, Object ... arguments) {
        return this.getText(LocaleContextHolder.getLocale(), key, fallbackMessage, arguments);
    }

    public String getMessagePattern(String key, String fallbackPattern) {
        String messagePattern = fallbackPattern;
        block2: for (Map.Entry<Plugin, Iterable<String>> entry : this.pluginResourceBundleNames.entrySet()) {
            for (String bundleName : entry.getValue()) {
                try {
                    ResourceBundle bundle = this.getBundle(bundleName, LocaleContextHolder.getLocale(), entry.getKey());
                    if (!bundle.containsKey(key)) continue;
                    messagePattern = bundle.getString(key);
                    continue block2;
                }
                catch (MissingResourceException e) {
                }
            }
        }
        return messagePattern;
    }

    public KeyedMessage getKeyedText(String key, String fallbackMessage, Object ... arguments) {
        return new KeyedMessage(key, this.getText(key, fallbackMessage, arguments), this.getText(Locale.ROOT, key, fallbackMessage, arguments));
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        Locale locale = LocaleContextHolder.getLocale();
        HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
        for (Plugin plugin : this.pluginResourceBundleNames.keySet()) {
            this.addMatchingTranslationsToMap(prefix, locale, plugin, this.pluginResourceBundleNames.get(plugin), translationsWithPrefix);
        }
        return translationsWithPrefix;
    }

    public Map<String, String> getAllTranslationsForPrefix(String prefix, Locale locale) {
        Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
        Preconditions.checkNotNull((Object)locale, (Object)"locale");
        HashMap<String, String> translationsWithPrefix = new HashMap<String, String>();
        for (Plugin plugin : this.pluginResourceBundleNames.keySet()) {
            this.addMatchingTranslationsToMap(prefix, locale, plugin, this.pluginResourceBundleNames.get(plugin), translationsWithPrefix);
        }
        return translationsWithPrefix;
    }

    public String getText(Locale locale, String key, String fallbackMessage, Object ... arguments) {
        String message = null;
        block2: for (Map.Entry<Plugin, Iterable<String>> entry : this.pluginResourceBundleNames.entrySet()) {
            for (String bundleName : entry.getValue()) {
                try {
                    ResourceBundle bundle = this.getBundle(bundleName, locale, entry.getKey());
                    if (!bundle.containsKey(key)) continue;
                    message = bundle.getString(key);
                    message = MessageFormat.format(message, arguments);
                    continue block2;
                }
                catch (MissingResourceException e) {
                }
            }
        }
        if (message == null) {
            message = this.formatFallbackMessage(key, fallbackMessage, arguments);
        }
        return message;
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.removePluginResourceBundles(event.getPlugin());
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.addPluginResourceBundles(event.getPlugin());
    }

    private String formatFallbackMessage(String key, String fallbackMessage, Object[] arguments) {
        String message;
        if (fallbackMessage == null) {
            message = key;
            if (arguments != null && arguments.length > 0) {
                StringBuilder sb = new StringBuilder(key);
                sb.append("[");
                String sep = "";
                for (Object argument : arguments) {
                    sb.append(sep);
                    sb.append(argument == null ? "(null)" : argument.toString());
                    sep = ", ";
                }
                sb.append("]");
                message = sb.toString();
            }
        } else {
            message = MessageFormat.format(fallbackMessage, arguments);
        }
        return message;
    }

    private void addMatchingTranslationsToMap(String prefix, Locale locale, Plugin plugin, Iterable<String> bundleNames, Map<String, String> translationsWithPrefix) {
        for (String bundleName : bundleNames) {
            try {
                ResourceBundle bundle = this.getBundle(bundleName, locale, plugin);
                if (bundle == null) continue;
                this.addMatchingTranslationsToMap(prefix, bundle, translationsWithPrefix);
            }
            catch (MissingResourceException e) {}
        }
    }

    private void addMatchingTranslationsToMap(String prefix, ResourceBundle bundle, Map<String, String> translationsWithPrefix) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            if (!key.startsWith(prefix)) continue;
            translationsWithPrefix.put(key, bundle.getString(key));
        }
    }

    private void addPluginResourceBundles(Plugin plugin) {
        Iterable descriptors = Iterables.filter((Iterable)plugin.getResourceDescriptors(), (Predicate)new Resources.TypeFilter("i18n"));
        ArrayList<String> bundleNames = new ArrayList<String>();
        for (ResourceDescriptor descriptor : descriptors) {
            bundleNames.add(descriptor.getLocation());
        }
        this.addPluginResourceBundles(plugin, bundleNames);
    }

    private void addPluginResourceBundles(Plugin plugin, List<String> bundleNames) {
        this.pluginResourceBundleNames.put(plugin, bundleNames);
    }

    private void removePluginResourceBundles(Plugin plugin) {
        this.pluginResourceBundleNames.remove(plugin);
    }

    protected ResourceBundle getBundle(String bundleName, Locale locale, Plugin plugin) {
        return ResourceBundle.getBundle(bundleName, locale, plugin.getClassLoader());
    }
}

