/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PasswordResetHelper {
    static final String PASSWORD_RESET_TOKEN_ATTRIBUTE = "passwordResetToken";
    static final String PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE = "passwordResetExpiration";
    private final CrowdService crowdService;
    private final long tokenValidityPeriod;

    @Autowired
    public PasswordResetHelper(CrowdService crowdService, @Value(value="${password.reset.validity.period}") int tokenValidityPeriod) {
        this.crowdService = crowdService;
        this.tokenValidityPeriod = TimeUnit.MINUTES.toMillis(tokenValidityPeriod);
    }

    public String getPasswordToken(UserWithAttributes user) {
        String token = user.getValue(PASSWORD_RESET_TOKEN_ATTRIBUTE);
        long expiration = NumberUtils.toLong((String)user.getValue(PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE));
        return token != null && expiration >= System.currentTimeMillis() ? token : null;
    }

    public void addResetPasswordToken(User user, String token) throws OperationNotPermittedException {
        this.crowdService.setUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE, token);
        this.crowdService.setUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE, Long.toString(System.currentTimeMillis() + this.tokenValidityPeriod));
    }

    public User findUserByResetToken(String token) {
        String name;
        UserWithAttributes user;
        Iterable users = this.crowdService.search((Query)new UserQuery(String.class, (SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)PASSWORD_RESET_TOKEN_ATTRIBUTE)).exactlyMatching((Object)token), 0, 1));
        if (users.iterator().hasNext() && (user = this.crowdService.getUserWithAttributes(name = (String)users.iterator().next())) != null) {
            return this.getPasswordToken(user) == null ? null : user;
        }
        return null;
    }

    public void resetPassword(User user, String password) throws OperationNotPermittedException, InvalidCredentialException {
        this.crowdService.updateUserCredential(user, password);
        this.crowdService.removeUserAttribute(user, PASSWORD_RESET_TOKEN_EXPIRATION_ATTRIBUTE);
        this.crowdService.removeUserAttribute(user, PASSWORD_RESET_TOKEN_ATTRIBUTE);
    }
}

