/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.internal.avatar.ResourceAvatarSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public enum AvatarType {
    PROJECT(1, "projects"){
        private final Map<Integer, String> idToColour = ImmutableMap.builder().put((Object)0, (Object)"blue").put((Object)1, (Object)"cyan").put((Object)2, (Object)"green").put((Object)3, (Object)"orange").put((Object)4, (Object)"red").put((Object)5, (Object)"yellow").build();

        @Override
        @Nonnull
        public AvatarSupplier loadDefault(@Nonnull String id, int size) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((boolean)DEFAULT_SIZES.contains(size), (Object)("Default project avatars are not available in " + size + "px"));
            int hash = id.hashCode();
            int selection = hash % this.idToColour.size();
            String colour = this.idToColour.get(selection);
            return new ResourceAvatarSupplier("avatars/project/" + colour + "/" + size + ".png");
        }
    }
    ,
    USER(2, "users"){

        @Override
        @Nonnull
        public AvatarSupplier loadDefault(@Nonnull String id, int size) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((boolean)DEFAULT_SIZES.contains(size), (Object)("Default user avatars are not available in " + size + "px"));
            return new ResourceAvatarSupplier("avatars/user/" + size + ".png");
        }
    };

    private static final Set<Integer> DEFAULT_SIZES;
    private final String directoryName;
    private final int id;

    private AvatarType(int id, String directoryName) {
        this.directoryName = (String)Preconditions.checkNotNull((Object)directoryName, (Object)"directoryName");
        this.id = id;
    }

    public static AvatarType fromId(int id) {
        for (AvatarType value : AvatarType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No AvatarType is available for ID " + id);
    }

    @Nonnull
    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public abstract AvatarSupplier loadDefault(@Nonnull String var1, int var2);

    @Nonnull
    public AvatarSupplier loadFixedDefault(int size) {
        return this.loadDefault("unknown", size);
    }

    static {
        DEFAULT_SIZES = ImmutableSet.of((Object)48, (Object)64, (Object)96, (Object)128, (Object)256);
    }
}

