/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.config;

import javax.annotation.Nonnull;

public enum Feature {
    ATTACHMENTS("attachments"),
    AUTH_CAPTCHA("auth.captcha"),
    FORKS("forks"),
    GETTING_STARTED("getting.started.page"),
    PERSONAL_REPOS("personal.repos"),
    PUBLIC_ACCESS("public.access"),
    SOURCE_CODEMIRROR("source.codemirror");

    private final String key;

    private Feature(String key) {
        this.key = key;
    }

    @Nonnull
    public static Feature fromKey(String value) {
        for (Feature feature : Feature.values()) {
            if (!feature.getKey().equals(value)) continue;
            return feature;
        }
        throw new IllegalArgumentException("No Feature is associated with key [" + value + "]");
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }
}

