/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.db;

import com.atlassian.stash.internal.db.DbType;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DbTypeBean {
    private static final Function<DbType, DbTypeBean> FROM_DB_TYPE = new Function<DbType, DbTypeBean>(){

        public DbTypeBean apply(DbType dbType) {
            return new DbTypeBean(dbType);
        }
    };
    public static final DbTypeBean DEFAULT = DbTypeBean.forDbType(DbType.POSTGRES);
    public static final List<DbTypeBean> ALL = ImmutableList.copyOf((Collection)Lists.transform((List)DbType.AS_LIST, FROM_DB_TYPE));
    private final DbType adaptee;

    @Nonnull
    public static DbTypeBean forDbType(@Nonnull DbType dbType) {
        return (DbTypeBean)FROM_DB_TYPE.apply((Object)dbType);
    }

    @Nullable
    public static DbTypeBean forKey(@Nonnull String key) {
        return (DbTypeBean)DbType.forKey((String)key).map(FROM_DB_TYPE).getOrNull();
    }

    private DbTypeBean(DbType adaptee) {
        this.adaptee = adaptee;
    }

    @Nonnull
    public String generateUrl(String hostName, String databaseNameOrSid, int port) {
        return this.adaptee.generateUrl(hostName, databaseNameOrSid, port);
    }

    @Nonnull
    public String getDefaultDatabaseName() {
        return (String)this.adaptee.getDefaultDatabaseName().getOrElse((Object)"");
    }

    @Nonnull
    public String getDefaultHostName() {
        return (String)this.adaptee.getDefaultHostName().getOrElse((Object)"");
    }

    @Nonnull
    public String getDefaultPort() {
        return (String)this.adaptee.getDefaultPort().map(Functions.toStringFunction()).getOrElse((Object)"");
    }

    @Nonnull
    public String getDefaultUserName() {
        return (String)this.adaptee.getDefaultUserName().getOrElse((Object)"");
    }

    @Nonnull
    public String getDisplayNameKey() {
        return this.adaptee.getDisplayNameKey();
    }

    @Nonnull
    public String getDriverClassName() {
        return this.adaptee.getDriverClassName();
    }

    @Nonnull
    public String getKey() {
        return this.adaptee.getKey();
    }

    @Nonnull
    public String getHelpKey() {
        return this.adaptee.getHelpKey();
    }

    @Nonnull
    public String getProtocol() {
        return this.adaptee.getProtocol();
    }

    public boolean getUsesSid() {
        return this.adaptee.usesSid();
    }

    public boolean isDriverAvailable() {
        return this.adaptee.isDriverAvailable();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbTypeBean)) {
            return false;
        }
        DbTypeBean other = (DbTypeBean)o;
        return this.adaptee.equals((Object)other.adaptee);
    }

    public int hashCode() {
        return this.adaptee.hashCode();
    }

    public String toString() {
        return this.adaptee.toString();
    }
}

