/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.stash.avatar.AvatarSupplier;
import com.atlassian.stash.i18n.I18nService;
import com.atlassian.stash.internal.avatar.ResourceAvatarSupplier;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public enum AvatarType {
    PROJECT(1, "projects"){
        private final Map<Integer, String> idToColour = ImmutableMap.builder().put((Object)0, (Object)"blue").put((Object)1, (Object)"cyan").put((Object)2, (Object)"green").put((Object)3, (Object)"orange").put((Object)4, (Object)"red").put((Object)5, (Object)"yellow").build();
        private final Set<Integer> validSizes = ImmutableSet.of((Object)48, (Object)64, (Object)96, (Object)128, (Object)256);

        @Override
        @Nonnull
        public AvatarSupplier loadDefault(@Nonnull String id, int size) {
            Preconditions.checkNotNull((Object)id, (Object)"id");
            Preconditions.checkArgument((boolean)this.validSizes.contains(size), (Object)("Default project avatars are not available in " + size + "px"));
            int hash = id.hashCode();
            int selection = hash % this.idToColour.size();
            String colour = this.idToColour.get(selection);
            return new ResourceAvatarSupplier("avatars/project/" + colour + "/" + size + ".png");
        }
    };

    private final String directoryName;
    private final int id;

    private AvatarType(int id, String directoryName) {
        this.directoryName = (String)Preconditions.checkNotNull((Object)directoryName, (Object)"directoryName");
        this.id = id;
    }

    public static AvatarType fromId(int id) {
        for (AvatarType value : AvatarType.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No AvatarType is available for ID " + id);
    }

    @Nonnull
    public String getDirectoryName() {
        return this.directoryName;
    }

    public int getId() {
        return this.id;
    }

    @Nonnull
    public String getName(@Nonnull I18nService i18nService) {
        String defaultName = this.name().toLowerCase(Locale.US);
        return i18nService.getText("stash.avatar.type." + defaultName, defaultName, new Object[0]);
    }

    @Nonnull
    public abstract AvatarSupplier loadDefault(@Nonnull String var1, int var2);
}

