/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.auth;

import com.atlassian.stash.auth.HttpAuthenticationFailureContext;
import com.atlassian.stash.auth.HttpAuthenticationSuccessContext;
import com.atlassian.stash.scm.AuthenticationState;
import com.atlassian.stash.user.AuthenticationException;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class DefaultHttpAuthenticationContext
implements HttpAuthenticationFailureContext,
HttpAuthenticationSuccessContext {
    private AuthenticationException authenticationException;
    private AuthenticationState authenticationState;
    private final FilterChain chain;
    private final Object credentials;
    private final String authenticationMethod;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private StashUser user;
    private final String username;

    public DefaultHttpAuthenticationContext(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain, @Nonnull String method, @Nullable String username, @Nullable Object credentials) {
        this.authenticationMethod = (String)Preconditions.checkNotNull((Object)method, (Object)"authenticationMethod");
        this.authenticationState = AuthenticationState.NOT_AUTHENTICATED;
        this.chain = (FilterChain)Preconditions.checkNotNull((Object)chain, (Object)"filterChain");
        this.request = (HttpServletRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        this.response = (HttpServletResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
        this.username = username;
        this.credentials = credentials;
    }

    @Nonnull
    public AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }

    @Nonnull
    public AuthenticationException getAuthenticationException() {
        return this.authenticationException;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    @Nonnull
    public FilterChain getFilterChain() {
        return this.chain;
    }

    @Nonnull
    public String getMethod() {
        return this.authenticationMethod;
    }

    @Nonnull
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Nonnull
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Nonnull
    public StashUser getUser() {
        return this.user;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAuthenticated() {
        return this.authenticationState == AuthenticationState.AUTHENTICATED;
    }

    public void onFailure(@Nonnull AuthenticationState authenticationState, AuthenticationException exception) {
        this.authenticationException = exception;
        this.authenticationState = (AuthenticationState)Preconditions.checkNotNull((Object)authenticationState, (Object)"authenticationState");
    }

    public void onSuccess(StashUser newUser) {
        HttpSession session;
        if (this.user != null && newUser != null && !this.user.equals(newUser) && (session = this.request.getSession(false)) != null) {
            session.invalidate();
        }
        this.user = newUser;
        this.authenticationState = AuthenticationState.AUTHENTICATED;
    }

    public void setAuthenticationState(AuthenticationState authenticationState) {
        this.authenticationState = authenticationState;
    }

    public void setUser(StashUser user) {
        this.user = user;
    }
}

