/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.git;

import com.atlassian.stash.content.DiffSegmentType;
import org.apache.commons.lang.StringUtils;

public enum GitDiffSegmentType {
    ADDED(DiffSegmentType.ADDED, "+"),
    COMMENT("\\ "),
    CONTEXT(DiffSegmentType.CONTEXT, " "),
    REMOVED(DiffSegmentType.REMOVED, "-");

    private final String prefix;
    private final DiffSegmentType type;

    private GitDiffSegmentType(String prefix) {
        this(null, prefix);
    }

    private GitDiffSegmentType(DiffSegmentType type, String prefix) {
        this.prefix = prefix;
        this.type = type;
    }

    public static GitDiffSegmentType forLine(String line) {
        for (GitDiffSegmentType value : GitDiffSegmentType.values()) {
            if (!StringUtils.startsWith((String)line, (String)value.getPrefix())) continue;
            return value;
        }
        return null;
    }

    public String dropPrefix(String line) {
        return line.substring(this.prefix.length());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public DiffSegmentType getType() {
        return this.type;
    }

    public boolean isValid() {
        return this.type != null;
    }
}

