/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm.git;

import com.atlassian.stash.content.ChangeType;
import org.apache.commons.lang.StringUtils;

public enum GitChangeType {
    ADD(ChangeType.ADD, "A"),
    COPY(ChangeType.COPY, "C", true),
    DELETE(ChangeType.DELETE, "D"),
    MODIFY(ChangeType.MODIFY, "M"),
    RENAME(ChangeType.MOVE, "R", true),
    TYPE(ChangeType.UNKNOWN, "T"),
    UNMERGED(ChangeType.UNKNOWN, "U"),
    UNKNOWN(ChangeType.UNKNOWN, "X");

    private final boolean scored;
    private final String status;
    private final ChangeType type;

    private GitChangeType(ChangeType type, String status) {
        this(type, status, false);
    }

    private GitChangeType(ChangeType type, String status, boolean scored) {
        this.scored = scored;
        this.status = status;
        this.type = type;
    }

    public static GitChangeType fromStatus(String status) {
        for (GitChangeType value : GitChangeType.values()) {
            if (!StringUtils.equals((String)status, (String)value.getStatus())) continue;
            return value;
        }
        return UNKNOWN;
    }

    public String getStatus() {
        return this.status;
    }

    public ChangeType getType() {
        return this.type;
    }

    public boolean isScored() {
        return this.scored;
    }
}

