/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.Scm2;
import com.atlassian.stash.scm.Scm3;
import com.atlassian.stash.scm.Scm4;
import com.atlassian.stash.scm.ScmAdapter;
import com.atlassian.stash.scm.ScmAdapter3;
import com.atlassian.stash.scm.ScmFeature;
import com.atlassian.stash.server.ApplicationPropertiesService;
import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScmAdapter4
extends ScmAdapter3
implements Scm4 {
    private static final Logger log = LoggerFactory.getLogger(ScmAdapter4.class);
    private final Function<Repository, Long> sizeFunction;

    public ScmAdapter4(@Nonnull Set<ScmFeature> features, @Nonnull Scm scm, ApplicationPropertiesService propertiesService) {
        super(features, scm);
        this.sizeFunction = scm instanceof Scm4 ? new DelegatingSizeFunction((Scm4)scm) : new DefaultSizeFunction(propertiesService);
    }

    @Nonnull
    public static Scm4 wrap(@Nonnull Scm scm, @Nonnull ApplicationPropertiesService propertiesService) {
        if (scm instanceof Scm3 && scm instanceof Scm4) {
            return (Scm4)scm;
        }
        Scm2 scm2 = ScmAdapter.wrap(scm);
        return new ScmAdapter4(scm2.getFeatures(), scm, propertiesService);
    }

    public long getSize(@Nonnull Repository repository) {
        return (Long)this.sizeFunction.apply((Object)repository);
    }

    private static class SizeFileVisitor
    extends SimpleFileVisitor<Path> {
        private long size;

        private SizeFileVisitor() {
        }

        public long getSize() {
            return this.size;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException e) throws IOException {
            if (e instanceof NoSuchFileException) {
                return FileVisitResult.CONTINUE;
            }
            throw e;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.size += attrs.size();
            return FileVisitResult.CONTINUE;
        }
    }

    private static class DelegatingSizeFunction
    implements Function<Repository, Long> {
        private final Scm4 scm;

        public DelegatingSizeFunction(Scm4 scm) {
            this.scm = scm;
        }

        public Long apply(Repository repository) {
            return this.scm.getSize(repository);
        }
    }

    private static class DefaultSizeFunction
    implements Function<Repository, Long> {
        private final ApplicationPropertiesService propertiesService;

        public DefaultSizeFunction(ApplicationPropertiesService propertiesService) {
            this.propertiesService = propertiesService;
        }

        public Long apply(Repository repository) {
            File repositoryDir = this.propertiesService.getRepositoryDir(repository);
            SizeFileVisitor visitor = new SizeFileVisitor();
            try {
                Files.walkFileTree(repositoryDir.toPath(), Collections.emptySet(), Integer.MAX_VALUE, visitor);
            }
            catch (IOException e) {
                log.warn("{}: Failed to calculate size", (Object)repository, (Object)e);
            }
            return visitor.getSize();
        }
    }
}

