/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AbstractScm;
import com.atlassian.stash.scm.PluginCommandBuilderFactory;
import com.atlassian.stash.scm.PluginCommandFactory;
import com.atlassian.stash.scm.Scm;
import com.atlassian.stash.scm.Scm2;
import com.atlassian.stash.scm.ScmFeature;
import com.atlassian.stash.scm.ScmStatus;
import com.atlassian.stash.scm.compare.PluginCompareCommandFactory;
import com.atlassian.stash.scm.hook.PluginHookHandlerFactory;
import com.atlassian.stash.scm.pull.PluginPullRequestCommandFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;

@Deprecated
public class ScmAdapter
extends AbstractScm {
    private static final Iterable<FeatureTest> TESTS = ImmutableList.builder().add((Object[])CommandTest.values()).add((Object[])FactoryTest.values()).build();
    private final Scm scm;

    public ScmAdapter(@Nonnull Set<ScmFeature> features, @Nonnull Scm scm) {
        super(features);
        this.scm = (Scm)Preconditions.checkNotNull((Object)scm, (Object)"scm");
    }

    public static Scm2 wrap(@Nonnull Scm scm) {
        if (scm instanceof Scm2) {
            return (Scm2)scm;
        }
        EnumSet<ScmFeature> features = EnumSet.noneOf(ScmFeature.class);
        for (FeatureTest test : TESTS) {
            if (!test.test(scm)) continue;
            features.add(test.getFeature());
        }
        return new ScmAdapter(features, scm);
    }

    public PluginCommandBuilderFactory getCommandBuilderFactory() {
        return this.scm.getCommandBuilderFactory();
    }

    @Nonnull
    public PluginCommandFactory getCommandFactory() {
        return this.scm.getCommandFactory();
    }

    public PluginCompareCommandFactory getCompareCommandFactory() {
        return this.scm.getCompareCommandFactory();
    }

    public PluginHookHandlerFactory getHookHandlerFactory() {
        return this.scm.getHookHandlerFactory();
    }

    @Nonnull
    public String getId() {
        return this.scm.getId();
    }

    @Nonnull
    public String getName() {
        return this.scm.getName();
    }

    public PluginPullRequestCommandFactory getPullRequestCommandFactory() {
        return this.scm.getPullRequestCommandFactory();
    }

    @Nonnull
    public ScmStatus getStatus() {
        return this.scm.getStatus();
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.scm.isEmpty(repository);
    }

    private static interface FeatureTest {
        @Nonnull
        public ScmFeature getFeature();

        public boolean test(@Nonnull Scm var1);
    }

    private static enum FactoryTest implements FeatureTest
    {
        COMMAND_BUILDERS(ScmFeature.COMMAND_BUILDERS){

            @Override
            protected Object get(@Nonnull Scm scm) {
                return scm.getCommandBuilderFactory();
            }
        }
        ,
        COMPARE(ScmFeature.COMPARE){

            @Override
            protected Object get(@Nonnull Scm scm) {
                return scm.getCompareCommandFactory();
            }
        }
        ,
        HOOKS(ScmFeature.HOOKS){

            @Override
            protected Object get(@Nonnull Scm scm) {
                return scm.getHookHandlerFactory();
            }
        }
        ,
        PULL_REQUESTS(ScmFeature.PULL_REQUESTS){

            @Override
            protected Object get(@Nonnull Scm scm) {
                return scm.getPullRequestCommandFactory();
            }
        }
        ,
        REFS(ScmFeature.REFS){

            @Override
            protected Object get(@Nonnull Scm scm) {
                return scm.getRefCommandFactory();
            }
        };

        private final ScmFeature feature;

        private FactoryTest(ScmFeature feature) {
            this.feature = feature;
        }

        @Override
        @Nonnull
        public ScmFeature getFeature() {
            return this.feature;
        }

        @Override
        public boolean test(@Nonnull Scm scm) {
            try {
                Object object = this.get((Scm)Preconditions.checkNotNull((Object)scm, (Object)"scm"));
                if (object != null) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        protected abstract Object get(@Nonnull Scm var1);
    }

    private static enum CommandTest implements FeatureTest
    {
        FORK(ScmFeature.FORK){

            @Override
            protected Object get(@Nonnull PluginCommandFactory factory) {
                return factory.fork(null, null);
            }
        }
        ,
        MERGE(ScmFeature.MERGE){

            @Override
            protected Object get(@Nonnull PluginCommandFactory factory) {
                return factory.merge(null, null);
            }
        }
        ,
        UPDATE_DEFAULT_BRANCH(ScmFeature.UPDATE_DEFAULT_BRANCH){

            @Override
            protected Object get(@Nonnull PluginCommandFactory factory) {
                return factory.updateDefaultBranch(null, null);
            }
        };

        private final ScmFeature feature;

        private CommandTest(ScmFeature feature) {
            this.feature = feature;
        }

        @Override
        @Nonnull
        public ScmFeature getFeature() {
            return this.feature;
        }

        @Override
        public boolean test(@Nonnull Scm scm) {
            try {
                Object object = this.get(((Scm)Preconditions.checkNotNull((Object)scm, (Object)"scm")).getCommandFactory());
                if (object != null) {
                    return true;
                }
            }
            catch (IllegalArgumentException | NullPointerException e) {
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        protected abstract Object get(@Nonnull PluginCommandFactory var1);
    }
}

