/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Change;
import com.atlassian.stash.content.Changeset;
import com.atlassian.stash.content.DetailedChangeset;
import com.atlassian.stash.content.MinimalChangeset;
import com.atlassian.stash.util.Page;
import com.atlassian.stash.util.PageUtils;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleDetailedChangeset
implements DetailedChangeset {
    private final MinimalChangeset fromCommit;
    private final Changeset toCommit;
    private final Page<? extends Change> changes;

    private SimpleDetailedChangeset(Builder builder) {
        this.fromCommit = builder.fromCommit;
        this.toCommit = builder.toCommit;
        this.changes = builder.changes;
    }

    @Nullable
    public MinimalChangeset getFromCommit() {
        return this.fromCommit;
    }

    @Nonnull
    public Changeset getToCommit() {
        return this.toCommit;
    }

    @Nullable
    public Page<? extends Change> getChanges() {
        return this.changes;
    }

    public static class Builder {
        private final Changeset toCommit;
        private Page<Change> changes;
        private MinimalChangeset fromCommit;

        public Builder(@Nonnull Changeset toCommit) {
            this.toCommit = (Changeset)Preconditions.checkNotNull((Object)toCommit, (Object)"toCommit");
        }

        @Nonnull
        public SimpleDetailedChangeset build() {
            return new SimpleDetailedChangeset(this);
        }

        @Nonnull
        public Builder changes(@Nullable Page<? extends Change> value) {
            this.changes = PageUtils.asPageOf(Change.class, value);
            return this;
        }

        @Nonnull
        public Builder fromCommit(@Nullable MinimalChangeset value) {
            this.fromCommit = value;
            return this;
        }
    }
}

