/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.atlassian.stash.content.Submodule;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalSubmodule
extends Submodule {
    private final String contentId;
    private final Path path;
    private final String url;
    private final String repositoryUrl;
    private final String browseUrl;

    private InternalSubmodule(Path path, String contentId, String url, String repositoryUrl, String browseUrl) {
        this.contentId = contentId;
        this.path = path;
        this.url = url;
        this.repositoryUrl = repositoryUrl;
        this.browseUrl = browseUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalSubmodule) {
            InternalSubmodule f = (InternalSubmodule)((Object)o);
            return Objects.equal((Object)this.getPath(), (Object)f.getPath()) && Objects.equal((Object)this.getContentId(), (Object)f.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBrowseUrl() {
        return this.browseUrl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "InternalSubmodule{path='" + this.path + '\'' + ", contentId='" + this.contentId + '\'' + ", url='" + this.url + '\'' + ", repositoryUrl='" + this.repositoryUrl + '\'' + ", browseUrl='" + this.browseUrl + '\'' + '}';
    }

    public static class Builder {
        private String contentId;
        private Path path;
        private String url;
        private String repositoryUrl;
        private String browseUrl;

        public Builder() {
        }

        public Builder(Submodule submodule) {
            this.path(submodule.getPath());
            this.contentId(submodule.getContentId());
            this.url(submodule.getUrl());
            this.repositoryUrl(submodule.getRepositoryUrl());
            this.browseUrl(submodule.getBrowseUrl());
        }

        public InternalSubmodule build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required");
            Preconditions.checkState((this.contentId != null ? 1 : 0) != 0, (Object)"A contentId is required");
            Preconditions.checkState((this.url != null ? 1 : 0) != 0, (Object)"A url is required");
            return new InternalSubmodule(this.path, this.contentId, this.url, this.repositoryUrl, this.browseUrl);
        }

        public Builder path(@Nonnull Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder contentId(@Nonnull String value) {
            this.contentId = (String)Preconditions.checkNotNull((Object)value, (Object)"contentId");
            return this;
        }

        public Builder url(@Nonnull String url) {
            this.url = (String)Preconditions.checkNotNull((Object)url, (Object)"url");
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public Builder browseUrl(String browseUrl) {
            this.browseUrl = browseUrl;
            return this;
        }

        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }
    }
}

