/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.ChangeType;
import com.atlassian.stash.content.ConflictChange;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalConflictChange
implements ConflictChange {
    private final Path path;
    private final Path srcPath;
    private final ChangeType type;

    private InternalConflictChange(ChangeType type, Path path, Path srcPath) {
        this.path = (Path)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.srcPath = srcPath;
        this.type = (ChangeType)Preconditions.checkNotNull((Object)type, (Object)"type");
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public Path getSrcPath() {
        return this.srcPath;
    }

    @Nonnull
    public ChangeType getType() {
        return this.type;
    }

    public static class Builder {
        private Path path;
        private Path srcPath;
        private ChangeType type;

        public Builder() {
        }

        public Builder(ConflictChange change) {
            this.path = change.getPath();
            this.srcPath = change.getSrcPath();
            this.type = change.getType();
        }

        public InternalConflictChange build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required");
            Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"A type is required");
            return new InternalConflictChange(this.type, this.path, this.srcPath);
        }

        public Builder path(Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder path(String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }

        public Builder srcPath(Path value) {
            this.srcPath = value;
            return this;
        }

        public Builder srcPath(String value) {
            return this.srcPath((Path)(value == null ? null : new SimplePath((CharSequence)value)));
        }

        public Builder type(ChangeType value) {
            this.type = (ChangeType)Preconditions.checkNotNull((Object)value);
            return this;
        }
    }
}

