/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.cgi;

import com.atlassian.stash.scm.CommandBuilder;
import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class CgiEnvironmentUtils {
    public static void applyStandardCgiEnvironment(CommandBuilder builder, HttpServletRequest request, ServletContext servletContext) {
        HashMap cgiEnv = Maps.newHashMap();
        cgiEnv.put("AUTH_TYPE", request.getAuthType());
        cgiEnv.put("CONTENT_LENGTH", Integer.toString(Math.max(0, request.getContentLength())));
        cgiEnv.put("CONTENT_TYPE", request.getContentType());
        cgiEnv.put("GATEWAY_INTERFACE", "CGI/1.1");
        cgiEnv.put("QUERY_STRING", request.getQueryString());
        cgiEnv.put("REMOTE_ADDR", request.getRemoteAddr());
        cgiEnv.put("REMOTE_HOST", request.getRemoteHost());
        cgiEnv.put("REQUEST_METHOD", request.getMethod());
        cgiEnv.put("SERVER_NAME", request.getServerName());
        cgiEnv.put("SERVER_PORT", Integer.toString(request.getServerPort()));
        cgiEnv.put("SERVER_PROTOCOL", request.getProtocol());
        cgiEnv.put("SERVER_SOFTWARE", servletContext.getServerInfo());
        Enumeration enm = request.getHeaderNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String value = request.getHeader(name);
            cgiEnv.put("HTTP_" + name.toUpperCase().replace('-', '_'), value);
        }
        cgiEnv.put("HTTPS", request.isSecure() ? "ON" : "OFF");
        for (Map.Entry env : cgiEnv.entrySet()) {
            if (StringUtils.isBlank((String)((String)env.getValue()))) continue;
            builder.environment((String)env.getKey(), (String)env.getValue());
        }
    }
}

