/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.web.cgi;

import com.atlassian.utils.process.Watchdog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCgiHandler {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseCgiHandler.class);
    private final int bufferSize;
    private Watchdog watchdog;

    public BaseCgiHandler(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setWatchdog(Watchdog watchdog) {
        this.watchdog = watchdog;
    }

    protected void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int read;
        if (this.watchdog == null) {
            throw new IllegalStateException("Watchdog not set on " + this.getClass().getSimpleName());
        }
        byte[] buffer = new byte[this.bufferSize];
        long bytesCopied = 0L;
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
            bytesCopied += (long)read;
            this.watchdog.resetWatchdog();
        }
        LOG.trace(bytesCopied + " bytes copied");
    }

    protected String getTextLineFromStream(InputStream inputStream) throws IOException {
        int b;
        StringBuilder buffer = new StringBuilder();
        while ((b = inputStream.read()) != -1 && b != 10) {
            buffer.append((char)b);
        }
        return buffer.toString().trim();
    }
}

