/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.io;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.mozilla.universalchardet.UniversalDetector;

public class ContentDetectionUtils {
    @Nullable
    public static String detectEncoding(@Nonnull BufferedInputStream stream, int bufferSize) throws IOException {
        Preconditions.checkNotNull((Object)stream, (Object)"stream");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"");
        byte[] buf = new byte[4];
        stream.mark(5);
        int read = stream.read(buf);
        stream.reset();
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(buf, 0, read);
        if (!detector.isDone()) {
            detector.reset();
            buf = new byte[bufferSize];
            stream.mark(buf.length);
            for (int remaining = buf.length; remaining > 0 && !detector.isDone() && (read = stream.read(buf, 0, remaining)) > 0; remaining -= read) {
                detector.handleData(buf, 0, read);
            }
            stream.reset();
            detector.dataEnd();
        }
        return detector.getDetectedCharset();
    }

    public static boolean isBinary(BufferedInputStream in, int bufferSize) throws IOException {
        int b;
        byte[] buf = new byte[4];
        in.mark(5);
        int len = in.read(buf);
        in.reset();
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(buf, 0, len);
        if (detector.isDone()) {
            return false;
        }
        in.mark(bufferSize);
        for (len = 0; (b = in.read()) != -1 && len < bufferSize - 192; ++len) {
            if (b != 0) continue;
            in.reset();
            return true;
        }
        in.reset();
        return false;
    }

    @Nullable
    public static String detectContentType(@Nonnull BufferedInputStream stream, @Nullable String path) throws IOException {
        String type = URLConnection.guessContentTypeFromStream((InputStream)Preconditions.checkNotNull((Object)stream, (Object)"stream"));
        if (StringUtils.isNotBlank((String)path)) {
            String pathType;
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(path);
            } else if ("application/xml".equals(type) && StringUtils.isNotBlank((String)(pathType = URLConnection.guessContentTypeFromName(path))) && pathType.endsWith("+xml")) {
                type = pathType;
            }
        }
        return type;
    }
}

