/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.home;

import com.atlassian.stash.home.HomeUpdate;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class SimpleHomeUpdate
implements HomeUpdate {
    private final String newDir;
    private final String oldDir;

    private SimpleHomeUpdate(String newDir, String oldDir) {
        this.newDir = newDir;
        this.oldDir = oldDir;
    }

    @Nonnull
    public String getNewDir() {
        return this.newDir;
    }

    @Nonnull
    public String getOldDir() {
        return this.oldDir;
    }

    public static class Builder {
        private String newDir;
        private String oldDir;

        public Builder() {
        }

        public Builder(@Nonnull HomeUpdate update) {
            this.newDir = ((HomeUpdate)Preconditions.checkNotNull((Object)update, (Object)"update")).getNewDir();
            this.oldDir = update.getOldDir();
        }

        @Nonnull
        public SimpleHomeUpdate build() {
            Preconditions.checkNotNull((Object)this.newDir, (Object)"newDir");
            Preconditions.checkNotNull((Object)this.oldDir, (Object)"oldDir");
            return new SimpleHomeUpdate(this.newDir, this.oldDir);
        }

        @Nonnull
        public Builder newDir(@Nonnull String value) {
            this.newDir = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder oldDir(@Nonnull String value) {
            this.oldDir = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }
    }
}

