/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import com.atlassian.stash.content.File;
import com.atlassian.stash.content.Path;
import com.atlassian.stash.content.SimplePath;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class InternalFile
extends File {
    private final String contentId;
    private final Path path;

    public InternalFile(Path path, String contentId) {
        this.contentId = contentId;
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalFile) {
            InternalFile f = (InternalFile)((Object)o);
            return Objects.equal((Object)this.getPath(), (Object)f.getPath()) && Objects.equal((Object)this.getContentId(), (Object)f.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "InternalFile{path='" + this.path + '\'' + ", contentId='" + this.contentId + '\'' + '}';
    }

    public static class Builder {
        private String contentId;
        private Path path;

        public Builder() {
        }

        public Builder(File file) {
            this.contentId = file.getContentId();
            this.path = file.getPath();
        }

        public InternalFile build() {
            return new InternalFile(this.path, this.contentId);
        }

        public Builder contentId(String value) {
            this.contentId = value;
            return this;
        }

        public Builder path(@Nonnull Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }
    }
}

